This is a simple plugin to serve static content from a local filesystem. It shares some of the same functionality as the `healthchecks` plugin, but can be used in the remap context(thereby making it reloadable). It does not use fsnotify for watching the source files.

If the file specified by the `--file-path` parameter is not found, the plugin will return the status code specified
by the `--failure-code` parameter, defaulting to a 404. If the file is found, it will return the contents of the file
setting the `Content-Type` header to the value specified on the `--mime-type` parameter.

Metrics
--------

The plugin publishes the following metrics:

statichit.response_bytes:
  The total number of bytes emitted
statichit.response_count:
  The number of HTTP responses generated by the plugin

Examples:
-----------

remap.config:
```
map /internal/healthcheck \
   http://127.0.0.1 \
   @plugin=statichit.so @pparam=--file-path=/var/run/trafficserver/healthcheck.txt \
   @pparam=--mime-type=text/plain \
   @pparam=--success-code=200 \
   @pparam=--failure-code=403 \
   @pparam=--max-age=0

map http://content.example.com/content.txt \
   http://127.0.0.1 \
   @plugin=statichit.so @pparam=--file-path=/opt/ats/etc/trafficserver/static/content_source.txt \
   @pparam=--failure-code=404 \
   @pparam=--max-age=604800

```

NOTE: The remap origin is never contacted because this plugin intercepts the request and acts as the origin server. For that reason, the origin specification must be syntactically valid and resolvable in DNS.
