# **********************************************************************
#
# Copyright (c) 2003-2005 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************

# Ice version 3.1.1
# Generated from file `SSLInfo.ice'

import Ice, IcePy, __builtin__
import Ice_BuiltinSequences_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Start of module Glacier2
_M_Glacier2 = Ice.openModule('Glacier2')
__name__ = 'Glacier2'

if not _M_Glacier2.__dict__.has_key('SSLInfo'):
    _M_Glacier2.SSLInfo = Ice.createTempClass()
    class SSLInfo(object):
        def __init__(self, remoteHost='', remotePort=0, localHost='', localPort=0, cipher='', certs=None):
            self.remoteHost = remoteHost
            self.remotePort = remotePort
            self.localHost = localHost
            self.localPort = localPort
            self.cipher = cipher
            self.certs = certs

        def __hash__(self):
            _h = 0
            _h = 5 * _h + __builtin__.hash(self.remoteHost)
            _h = 5 * _h + __builtin__.hash(self.remotePort)
            _h = 5 * _h + __builtin__.hash(self.localHost)
            _h = 5 * _h + __builtin__.hash(self.localPort)
            _h = 5 * _h + __builtin__.hash(self.cipher)
            if self.certs:
                for _i0 in self.certs:
                    _h = 5 * _h + __builtin__.hash(_i0)
            return _h % 0x7fffffff

        def __eq__(self, other):
            if not self.remoteHost == other.remoteHost:
                return False
            if not self.remotePort == other.remotePort:
                return False
            if not self.localHost == other.localHost:
                return False
            if not self.localPort == other.localPort:
                return False
            if not self.cipher == other.cipher:
                return False
            if not self.certs == other.certs:
                return False
            return True

        def __str__(self):
            return IcePy.stringify(self, _M_Glacier2._t_SSLInfo)

        __repr__ = __str__

    _M_Glacier2._t_SSLInfo = IcePy.defineStruct('::Glacier2::SSLInfo', SSLInfo, (
        ("remoteHost", IcePy._t_string),
        ("remotePort", IcePy._t_int),
        ("localHost", IcePy._t_string),
        ("localPort", IcePy._t_int),
        ("cipher", IcePy._t_string),
        ("certs", _M_Ice._t_StringSeq)
    ))

    _M_Glacier2.SSLInfo = SSLInfo
    del SSLInfo

# End of module Glacier2

Ice.sliceChecksums["::Glacier2::SSLInfo"] = "ca63bc6d361a48471c4d16ea29818e5"
