/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CollocationOptimizationException;
import Ice.NoEndpointException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RouterPrx;
import IceInternal.EndpointI;
import java.util.HashSet;

public final class RouterInfo {
    private final RouterPrx _router;
    private EndpointI[] _clientEndpoints;
    private EndpointI[] _serverEndpoints;
    private ObjectAdapter _adapter;
    private HashSet _identities = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    RouterInfo(RouterPrx router) {
        this._router = router;
        if (!$assertionsDisabled && this._router == null) {
            throw new AssertionError();
        }
    }

    public synchronized void destroy() {
        this._clientEndpoints = new EndpointI[0];
        this._serverEndpoints = new EndpointI[0];
        this._adapter = null;
        this._identities.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouterInfo) {
            return this._router.equals(((RouterInfo)obj)._router);
        }
        return false;
    }

    public RouterPrx getRouter() {
        return this._router;
    }

    public synchronized EndpointI[] getClientEndpoints() {
        if (this._clientEndpoints == null) {
            ObjectPrx clientProxy = this._router.getClientProxy();
            if (clientProxy == null) {
                this._clientEndpoints = ((ObjectPrxHelperBase)((Object)this._router)).__reference().getEndpoints();
            } else {
                clientProxy = clientProxy.ice_router(null);
                try {
                    clientProxy = clientProxy.ice_timeout(this._router.ice_getConnection().timeout());
                }
                catch (CollocationOptimizationException collocationOptimizationException) {
                    // empty catch block
                }
                this._clientEndpoints = ((ObjectPrxHelperBase)clientProxy).__reference().getEndpoints();
            }
        }
        return this._clientEndpoints;
    }

    public synchronized EndpointI[] getServerEndpoints() {
        if (this._serverEndpoints == null) {
            ObjectPrx serverProxy = this._router.getServerProxy();
            if (serverProxy == null) {
                throw new NoEndpointException();
            }
            serverProxy = serverProxy.ice_router(null);
            this._serverEndpoints = ((ObjectPrxHelperBase)serverProxy).__reference().getEndpoints();
        }
        return this._serverEndpoints;
    }

    public synchronized void addProxy(ObjectPrx proxy) {
        if (!$assertionsDisabled && proxy == null) {
            throw new AssertionError();
        }
        if (!this._identities.contains(proxy.ice_getIdentity())) {
            ObjectPrx[] proxies = new ObjectPrx[]{proxy};
            ObjectPrx[] evictedProxies = this._router.addProxies(proxies);
            this._identities.add(proxy.ice_getIdentity());
            for (int i = 0; i < evictedProxies.length; ++i) {
                this._identities.remove(evictedProxies[i].ice_getIdentity());
            }
        }
    }

    public synchronized void setAdapter(ObjectAdapter adapter) {
        this._adapter = adapter;
    }

    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }

    static {
        $assertionsDisabled = !RouterInfo.class.desiredAssertionStatus();
    }
}

