/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import IceGridGUI.Application.TreeNode;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class ApplicationActions {
    private TreeNode _target;
    private Action[] _array = new Action[20];

    public Action get(int index) {
        return this._array[index];
    }

    public boolean[] setTarget(TreeNode target) {
        this._target = target;
        boolean[] availableActions = this._target == null ? new boolean[20] : this._target.getAvailableActions();
        for (int i = 0; i < this._array.length; ++i) {
            this._array[i].setEnabled(availableActions[i]);
        }
        return availableActions;
    }

    ApplicationActions(boolean popup) {
        int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._array[0] = new AbstractAction(popup ? "New Adapter" : "Adapter"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newAdapter();
                }
            }
        };
        this._array[1] = new AbstractAction(popup ? "New Database Environment" : "Database Environment"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newDbEnv();
                }
            }
        };
        this._array[2] = new AbstractAction(popup ? "New Node" : "Node"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newNode();
                }
            }
        };
        this._array[3] = new AbstractAction(popup ? "New Property Set" : "Property Set"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newPropertySet();
                }
            }
        };
        this._array[4] = new AbstractAction(popup ? "New Replica Group" : "Replica Group"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newReplicaGroup();
                }
            }
        };
        this._array[5] = new AbstractAction(popup ? "New Server" : "Server"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newServer();
                }
            }
        };
        this._array[6] = new AbstractAction(popup ? "New IceBox Server" : "IceBox Server"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newServerIceBox();
                }
            }
        };
        this._array[7] = new AbstractAction(popup ? "New Server from Template" : "Server from Template"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newServerFromTemplate();
                }
            }
        };
        this._array[8] = new AbstractAction(popup ? "New Service" : "Service"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newService();
                }
            }
        };
        this._array[9] = new AbstractAction(popup ? "New Service from Template" : "Service from Template"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newServiceFromTemplate();
                }
            }
        };
        this._array[10] = new AbstractAction(popup ? "New Server Template" : "Server Template"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newTemplateServer();
                }
            }
        };
        this._array[11] = new AbstractAction(popup ? "New IceBox Server Template" : "IceBox Server Template"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newTemplateServerIceBox();
                }
            }
        };
        this._array[12] = new AbstractAction(popup ? "New Service Template" : "Service Template"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.newTemplateService();
                }
            }
        };
        this._array[13] = new AbstractAction("Copy"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.copy();
            }
        };
        this._array[14] = new AbstractAction("Paste"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.paste();
                }
            }
        };
        this._array[15] = new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.delete();
            }
        };
        this._array[16] = new AbstractAction("Show Variables"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.getCoordinator().showVars();
            }
        };
        this._array[16].putValue("ShortDescription", "Show variables and parameters in the Properties pane");
        this._array[17] = new AbstractAction("Substitute Variables"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.getCoordinator().substituteVars();
            }
        };
        this._array[17].putValue("ShortDescription", "Substitute variables and parameters with their values in the Properties pane");
        this._array[18] = new AbstractAction("Move Up"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.moveUp();
                }
            }
        };
        this._array[19] = new AbstractAction("Move Down"){

            public void actionPerformed(ActionEvent e) {
                if (ApplicationActions.apply(ApplicationActions.this._target)) {
                    ApplicationActions.this._target.moveDown();
                }
            }
        };
    }

    private static boolean apply(TreeNode target) {
        return target.getRoot().getPane().applyUpdates(false);
    }
}

