/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionLostException;
import Ice.Logger;
import Ice.SocketException;
import Ice.Stats;
import Ice.TimeoutException;
import IceInternal.BasicStream;
import IceInternal.Instance;
import IceInternal.LocalExceptionWrapper;
import IceInternal.Network;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import IceUtil.Assert;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

final class TcpTransceiver
implements Transceiver {
    private SocketChannel _fd;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private Stats _stats;
    private String _desc;
    private Selector _readSelector;
    private Selector _writeSelector;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SelectableChannel fd() {
        if (!$assertionsDisabled && this._fd == null) {
            throw new AssertionError();
        }
        return this._fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this._traceLevels.network >= 1) {
            String s = "closing tcp connection\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        TcpTransceiver tcpTransceiver = this;
        synchronized (tcpTransceiver) {
            if (!$assertionsDisabled && this._fd == null) {
                throw new AssertionError();
            }
            if (this._readSelector != null) {
                try {
                    this._readSelector.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this._readSelector = null;
            }
            if (this._writeSelector != null) {
                try {
                    this._writeSelector.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this._writeSelector = null;
            }
            try {
                this._fd.close();
            }
            catch (IOException ex) {
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
            finally {
                this._fd = null;
            }
        }
    }

    public void shutdownWrite() {
        if (this._traceLevels.network >= 2) {
            String s = "shutting down tcp connection for writing\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        if (!$assertionsDisabled && this._fd == null) {
            throw new AssertionError();
        }
        Socket socket = this._fd.socket();
        try {
            socket.shutdownOutput();
        }
        catch (java.net.SocketException ex) {
            if (Network.notConnected(ex)) {
                return;
            }
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public void shutdownReadWrite() {
        if (this._traceLevels.network >= 2) {
            String s = "shutting down tcp connection for reading and writing\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        if (!$assertionsDisabled && this._fd == null) {
            throw new AssertionError();
        }
        Socket socket = this._fd.socket();
        try {
            socket.shutdownInput();
            socket.shutdownOutput();
        }
        catch (java.net.SocketException ex) {
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public void write(BasicStream stream, int timeout) throws LocalExceptionWrapper {
        ByteBuffer buf = stream.prepareWrite();
        while (buf.hasRemaining()) {
            try {
                if (!$assertionsDisabled && this._fd == null) {
                    throw new AssertionError();
                }
                int ret = this._fd.write(buf);
                if (ret == -1) {
                    throw new ConnectionLostException();
                }
                if (ret == 0) {
                    if (timeout == 0) {
                        throw new TimeoutException();
                    }
                    if (this._writeSelector == null) {
                        this._writeSelector = Selector.open();
                        this._fd.register(this._writeSelector, 4, null);
                    }
                    try {
                        if (timeout > 0) {
                            long start = System.currentTimeMillis();
                            int n = this._writeSelector.select(timeout);
                            if (n != 0 || System.currentTimeMillis() < start + (long)timeout) continue;
                            throw new TimeoutException();
                        }
                        this._writeSelector.select();
                    }
                    catch (InterruptedIOException ex) {}
                    continue;
                }
                if (this._traceLevels.network >= 3) {
                    String s = "sent " + ret + " of " + buf.limit() + " bytes via tcp\n" + this.toString();
                    this._logger.trace(this._traceLevels.networkCat, s);
                }
                if (this._stats == null) continue;
                this._stats.bytesSent(this.type(), ret);
            }
            catch (InterruptedIOException ex) {
            }
            catch (IOException ex) {
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
    }

    public boolean read(BasicStream stream, int timeout) {
        ByteBuffer buf = stream.prepareRead();
        int remaining = 0;
        if (this._traceLevels.network >= 3) {
            remaining = buf.remaining();
        }
        while (buf.hasRemaining()) {
            try {
                if (!$assertionsDisabled && this._fd == null) {
                    throw new AssertionError();
                }
                int ret = this._fd.read(buf);
                if (ret == -1) {
                    throw new ConnectionLostException();
                }
                if (ret == 0) {
                    if (timeout == 0) {
                        throw new TimeoutException();
                    }
                    if (this._readSelector == null) {
                        this._readSelector = Selector.open();
                        this._fd.register(this._readSelector, 1, null);
                    }
                    try {
                        if (timeout > 0) {
                            long start = System.currentTimeMillis();
                            int n = this._readSelector.select(timeout);
                            if (n != 0 || System.currentTimeMillis() < start + (long)timeout) continue;
                            throw new TimeoutException();
                        }
                        this._readSelector.select();
                    }
                    catch (InterruptedIOException ex) {}
                    continue;
                }
                if (ret <= 0) continue;
                if (this._traceLevels.network >= 3) {
                    String s = "received " + ret + " of " + remaining + " bytes via tcp\n" + this.toString();
                    this._logger.trace(this._traceLevels.networkCat, s);
                }
                if (this._stats == null) continue;
                this._stats.bytesReceived(this.type(), ret);
            }
            catch (InterruptedIOException ex) {
            }
            catch (IOException ex) {
                if (Network.connectionLost(ex)) {
                    ConnectionLostException se = new ConnectionLostException();
                    se.initCause(ex);
                    throw se;
                }
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
        return false;
    }

    public String type() {
        return "tcp";
    }

    public String toString() {
        return this._desc;
    }

    TcpTransceiver(Instance instance, SocketChannel fd) {
        this._fd = fd;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.initializationData().logger;
        this._stats = instance.initializationData().stats;
        this._desc = Network.fdToString(this._fd);
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._fd == null);
        super.finalize();
    }

    static {
        $assertionsDisabled = !TcpTransceiver.class.desiredAssertionStatus();
    }
}

