/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Logger;
import IceInternal.Connector;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TcpTransceiver;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

final class TcpConnector
implements Connector {
    private Instance _instance;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private InetSocketAddress _addr;

    public Transceiver connect(int timeout) {
        if (this._traceLevels.network >= 2) {
            String s = "trying to establish tcp connection to " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        SocketChannel fd = Network.createTcpSocket();
        Network.setBlock(fd, false);
        Network.doConnect(fd, this._addr, timeout);
        if (this._traceLevels.network >= 1) {
            String s = "tcp connection established\n" + Network.fdToString(fd);
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        return new TcpTransceiver(this._instance, fd);
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    TcpConnector(Instance instance, String host, int port) {
        this._instance = instance;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.initializationData().logger;
        this._addr = Network.getAddress(host, port);
    }
}

