/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import Ice.Identity;
import Ice.LocalException;
import Ice.ObjectPrx;
import Ice.UserException;
import Ice.Util;
import IceGrid.AMI_Admin_patchApplication;
import IceGrid.AMI_Admin_removeAdapter;
import IceGrid.AMI_Admin_removeObject;
import IceGrid.AdapterDynamicInfo;
import IceGrid.AdapterInfo;
import IceGrid.ApplicationDescriptor;
import IceGrid.ApplicationUpdateDescriptor;
import IceGrid.DeploymentException;
import IceGrid.NodeDescriptor;
import IceGrid.NodeDynamicInfo;
import IceGrid.NodeUpdateDescriptor;
import IceGrid.ObjectExistsException;
import IceGrid.ObjectInfo;
import IceGrid.PropertySetDescriptor;
import IceGrid.ReplicaGroupDescriptor;
import IceGrid.ServerDynamicInfo;
import IceGridGUI.Coordinator;
import IceGridGUI.LiveActions;
import IceGridGUI.LiveDeployment.Editor;
import IceGridGUI.LiveDeployment.ListTreeNode;
import IceGridGUI.LiveDeployment.Node;
import IceGridGUI.LiveDeployment.ObjectDialog;
import IceGridGUI.LiveDeployment.RegistryEditor;
import IceGridGUI.LiveDeployment.TreeNode;
import IceGridGUI.Utils;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class Root
extends ListTreeNode {
    private final Coordinator _coordinator;
    private final Map _descriptorMap = new TreeMap();
    private SortedMap _adapters = new TreeMap();
    private SortedMap _objects = new TreeMap();
    private final JTree _tree;
    private final DefaultTreeModel _treeModel;
    private String _label;
    private ObjectDialog _objectDialog;
    private static RegistryEditor _editor;
    private static JPopupMenu _popup;
    private static DefaultTreeCellRenderer _cellRenderer;

    public Root(Coordinator coordinator) {
        super(null, "Root");
        this._coordinator = coordinator;
        this._tree = new JTree(this, true);
        this._treeModel = (DefaultTreeModel)this._tree.getModel();
        this._objectDialog = new ObjectDialog(this);
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[7];
        actions[6] = true;
        return actions;
    }

    public ApplicationDescriptor getApplicationDescriptor(String name) {
        return (ApplicationDescriptor)this._descriptorMap.get(name);
    }

    public Object[] getApplicationNames() {
        return this._descriptorMap.keySet().toArray();
    }

    public Object[] getPatchableApplicationNames() {
        ArrayList result = new ArrayList();
        Iterator p = this._descriptorMap.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            ApplicationDescriptor app = (ApplicationDescriptor)entry.getValue();
            if (app.distrib.icepatch.length() <= 0) continue;
            result.add(entry.getKey());
        }
        return result.toArray();
    }

    public Editor getEditor() {
        if (_editor == null) {
            _editor = new RegistryEditor();
        }
        _editor.show(this);
        return _editor;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            ImageIcon icon = Utils.getIcon("/icons/16x16/registry.png");
            _cellRenderer.setOpenIcon(icon);
            _cellRenderer.setClosedIcon(icon);
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public void init(String instanceName, List applications, AdapterInfo[] adapters, ObjectInfo[] objects) {
        int i;
        this._label = instanceName;
        this._tree.setRootVisible(true);
        for (i = 0; i < adapters.length; ++i) {
            this._adapters.put(adapters[i].id, adapters[i]);
        }
        for (i = 0; i < objects.length; ++i) {
            this._objects.put(Util.identityToString(objects[i].proxy.ice_getIdentity()), objects[i]);
        }
        Iterator p = applications.iterator();
        while (p.hasNext()) {
            this.applicationAdded((ApplicationDescriptor)p.next());
        }
    }

    public void clear() {
        this._adapters.clear();
        this._objects.clear();
        this._descriptorMap.clear();
        this._children.clear();
        this._treeModel.nodeStructureChanged(this);
        this._tree.setRootVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patch(final String applicationName) {
        int shutdown = JOptionPane.showConfirmDialog(this.getCoordinator().getMainFrame(), "You are about to install or refresh your application distribution.\n Do you want shut down all servers affected by this update?", "Patch Confirmation", 1);
        if (shutdown == 2) {
            return;
        }
        final String prefix = "Patching application '" + applicationName + "'...";
        this._coordinator.getStatusBar().setText(prefix);
        AMI_Admin_patchApplication cb = new AMI_Admin_patchApplication(){

            public void ice_response() {
                Root.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Root.this.amiFailure(prefix, "Failed to patch '" + applicationName + "'", e);
            }

            public void ice_exception(LocalException e) {
                Root.this.amiFailure(prefix, "Failed to patch '" + applicationName + "'", e.toString());
            }
        };
        try {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this._coordinator.getAdmin().patchApplication_async(cb, applicationName, shutdown == 0);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to patch " + this._id, e.toString());
        }
        finally {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void applicationAdded(ApplicationDescriptor desc) {
        this._descriptorMap.put(desc.name, desc);
        Iterator p = desc.nodes.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            String nodeName = (String)entry.getKey();
            NodeDescriptor nodeDesc = (NodeDescriptor)entry.getValue();
            Node node = this.findNode(nodeName);
            if (node == null) {
                this.insertNode(new Node(this, desc, nodeName, nodeDesc));
                continue;
            }
            node.add(desc, nodeDesc);
        }
    }

    public void applicationRemoved(String name) {
        this._descriptorMap.remove(name);
        LinkedList<Node> toRemove = new LinkedList<Node>();
        int[] toRemoveIndices = new int[this._children.size()];
        int i = 0;
        for (int index = 0; index < this._children.size(); ++index) {
            Node node = (Node)this._children.get(index);
            if (!node.remove(name)) continue;
            toRemove.add(node);
            toRemoveIndices[i++] = index;
        }
        this.removeNodes(this.resize(toRemoveIndices, toRemove.size()), toRemove);
    }

    public void applicationUpdated(ApplicationUpdateDescriptor update) {
        int i;
        ApplicationDescriptor appDesc = (ApplicationDescriptor)this._descriptorMap.get(update.name);
        if (update.description != null) {
            appDesc.description = update.description.value;
        }
        if (update.distrib != null) {
            appDesc.distrib = update.distrib.value;
        }
        appDesc.variables.keySet().removeAll(Arrays.asList(update.removeVariables));
        appDesc.variables.putAll(update.variables);
        boolean variablesChanged = update.removeVariables.length > 0 || !update.variables.isEmpty();
        appDesc.propertySets.keySet().removeAll(Arrays.asList(update.removePropertySets));
        appDesc.propertySets.putAll(update.propertySets);
        block0: for (i = 0; i < update.removeReplicaGroups.length; ++i) {
            for (int j = 0; j < appDesc.replicaGroups.size(); ++j) {
                ReplicaGroupDescriptor rgd = (ReplicaGroupDescriptor)appDesc.replicaGroups.get(j);
                if (!rgd.id.equals(update.removeReplicaGroups[i])) continue;
                appDesc.replicaGroups.remove(j);
                continue block0;
            }
        }
        for (i = 0; i < update.replicaGroups.size(); ++i) {
            ReplicaGroupDescriptor newRgd = (ReplicaGroupDescriptor)update.replicaGroups.get(i);
            boolean replaced = false;
            for (int j = 0; j < appDesc.replicaGroups.size() && !replaced; ++j) {
                ReplicaGroupDescriptor oldRgd = (ReplicaGroupDescriptor)appDesc.replicaGroups.get(j);
                if (!newRgd.id.equals(oldRgd.id)) continue;
                appDesc.replicaGroups.set(j, newRgd);
                replaced = true;
            }
            if (replaced) continue;
            appDesc.replicaGroups.add(newRgd);
        }
        appDesc.serviceTemplates.keySet().removeAll(Arrays.asList(update.removeServiceTemplates));
        appDesc.serviceTemplates.putAll(update.serviceTemplates);
        appDesc.serverTemplates.keySet().removeAll(Arrays.asList(update.removeServerTemplates));
        appDesc.serverTemplates.putAll(update.serverTemplates);
        appDesc.nodes.keySet().removeAll(Arrays.asList(update.removeNodes));
        for (i = 0; i < update.removeNodes.length; ++i) {
            Node node = this.findNode(update.removeNodes[i]);
            if (!node.remove(update.name)) continue;
            int index = this.getIndex(node);
            this._children.remove(node);
            this._treeModel.nodesWereRemoved(this, new int[]{index}, new Object[]{node});
        }
        Iterator p = update.nodes.iterator();
        HashSet<Node> freshNodes = new HashSet<Node>();
        while (p.hasNext()) {
            NodeUpdateDescriptor nodeUpdateDesc = (NodeUpdateDescriptor)p.next();
            String nodeName = nodeUpdateDesc.name;
            Node node = this.findNode(nodeName);
            if (node == null) {
                node = new Node(this, appDesc, nodeUpdateDesc);
                this.insertNode(node);
            } else {
                node.update(appDesc, nodeUpdateDesc, variablesChanged, update.serviceTemplates.keySet(), update.serverTemplates.keySet());
            }
            freshNodes.add(node);
        }
        if (variablesChanged || !update.serviceTemplates.isEmpty() || !update.serverTemplates.isEmpty()) {
            p = this._children.iterator();
            while (p.hasNext()) {
                Node node = (Node)p.next();
                if (freshNodes.contains(node)) continue;
                node.update(appDesc, null, variablesChanged, update.serviceTemplates.keySet(), update.serverTemplates.keySet());
            }
        }
    }

    public void adapterAdded(AdapterInfo info) {
        this._adapters.put(info.id, info);
    }

    public void adapterUpdated(AdapterInfo info) {
        this._adapters.put(info.id, info);
    }

    public void adapterRemoved(String id) {
        this._adapters.remove(id);
    }

    public void objectAdded(ObjectInfo info) {
        this._objects.put(Util.identityToString(info.proxy.ice_getIdentity()), info);
    }

    public void objectUpdated(ObjectInfo info) {
        this._objects.put(Util.identityToString(info.proxy.ice_getIdentity()), info);
    }

    public void objectRemoved(Identity id) {
        this._objects.remove(Util.identityToString(id));
    }

    public void nodeUp(NodeDynamicInfo updatedInfo) {
        Node node = this.findNode(updatedInfo.name);
        if (node != null) {
            node.up(updatedInfo, true);
        } else {
            this.insertNode(new Node(this, updatedInfo));
        }
    }

    public void nodeDown(String nodeName) {
        Node node = this.findNode(nodeName);
        if (node != null && node.down()) {
            int index = this.getIndex(node);
            this._children.remove(node);
            this._treeModel.nodesWereRemoved(this, new int[]{index}, new Object[]{node});
        }
    }

    public void updateServer(String nodeName, ServerDynamicInfo updatedInfo) {
        Node node = this.findNode(nodeName);
        if (node != null) {
            node.updateServer(updatedInfo);
        }
    }

    public void updateAdapter(String nodeName, AdapterDynamicInfo updatedInfo) {
        Node node = this.findNode(nodeName);
        if (node != null) {
            node.updateAdapter(updatedInfo);
        }
    }

    public JPopupMenu getPopupMenu() {
        LiveActions la = this._coordinator.getLiveActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(la.get(6));
        }
        la.setTarget(this);
        return _popup;
    }

    public void setSelectedNode(TreeNode node) {
        this._tree.setSelectionPath(node.getPath());
    }

    public JTree getTree() {
        return this._tree;
    }

    public DefaultTreeModel getTreeModel() {
        return this._treeModel;
    }

    public Coordinator getCoordinator() {
        return this._coordinator;
    }

    public String toString() {
        return this._label;
    }

    public boolean hasNode(TreeNode node) {
        while (node != this) {
            TreeNode parent = (TreeNode)node.getParent();
            if (parent.getIndex(node) == -1) {
                return false;
            }
            node = parent;
        }
        return true;
    }

    public void addObject() {
        this._objectDialog.showDialog();
    }

    Root getRoot() {
        return this;
    }

    SortedMap getObjects() {
        return this._objects;
    }

    SortedMap getAdapters() {
        return this._adapters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addObject(String strProxy, String type) {
        ObjectPrx proxy = null;
        try {
            proxy = this._coordinator.getCommunicator().stringToProxy(strProxy);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), "Cannot parse proxy '" + strProxy + "'", "addObject failed", 0);
            return false;
        }
        if (proxy == null) {
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), "You must provide a non-null proxy", "addObject failed", 0);
            return false;
        }
        String strIdentity = Util.identityToString(proxy.ice_getIdentity());
        String prefix = "Adding well-known object '" + strIdentity + "'...";
        try {
            this._coordinator.getStatusBar().setText(prefix);
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            if (type == null) {
                this._coordinator.getAdmin().addObject(proxy);
            } else {
                this._coordinator.getAdmin().addObjectWithType(proxy, type);
            }
        }
        catch (ObjectExistsException e) {
            this._coordinator.getStatusBar().setText(prefix + "failed.");
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), "An object with this identity is already registered as a well-known object", "addObject failed", 0);
            boolean bl = false;
            return bl;
        }
        catch (DeploymentException e) {
            this._coordinator.getStatusBar().setText(prefix + "failed.");
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), "Deployment exception: " + e.reason, "addObject failed", 0);
            boolean bl = false;
            return bl;
        }
        catch (LocalException e) {
            this._coordinator.getStatusBar().setText(prefix + "failed.");
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), e.toString(), "addObject failed", 0);
            boolean bl = false;
            return bl;
        }
        finally {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
        this._coordinator.getStatusBar().setText(prefix + "done.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObject(String strProxy) {
        ObjectPrx proxy = this._coordinator.getCommunicator().stringToProxy(strProxy);
        Identity identity = proxy.ice_getIdentity();
        final String strIdentity = Util.identityToString(identity);
        final String prefix = "Removing well-known object '" + strIdentity + "'...";
        this._coordinator.getStatusBar().setText(prefix);
        AMI_Admin_removeObject cb = new AMI_Admin_removeObject(){

            public void ice_response() {
                Root.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Root.this.amiFailure(prefix, "Failed to remove object '" + strIdentity + "'", e);
            }

            public void ice_exception(LocalException e) {
                Root.this.amiFailure(prefix, "Failed to remove object '" + strIdentity + "'", e.toString());
            }
        };
        try {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this._coordinator.getAdmin().removeObject_async(cb, identity);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to remove object '" + strIdentity + "'", e.toString());
        }
        finally {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAdapter(final String adapterId) {
        final String prefix = "Removing adapter '" + adapterId + "'...";
        this._coordinator.getStatusBar().setText(prefix);
        AMI_Admin_removeAdapter cb = new AMI_Admin_removeAdapter(){

            public void ice_response() {
                Root.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Root.this.amiFailure(prefix, "Failed to remove adapter '" + adapterId + "'", e);
            }

            public void ice_exception(LocalException e) {
                Root.this.amiFailure(prefix, "Failed to remove adapter '" + adapterId + "'", e.toString());
            }
        };
        try {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this._coordinator.getAdmin().removeAdapter_async(cb, adapterId);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to remove adapter '" + adapterId + "'", e.toString());
        }
        finally {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    PropertySetDescriptor findNamedPropertySet(String name, String applicationName) {
        ApplicationDescriptor descriptor = (ApplicationDescriptor)this._descriptorMap.get(applicationName);
        return (PropertySetDescriptor)descriptor.propertySets.get(name);
    }

    private Node findNode(String nodeName) {
        return (Node)this.find(nodeName, this._children);
    }

    private void insertNode(Node node) {
        int i;
        String nodeName = node.toString();
        for (i = 0; i < this._children.size(); ++i) {
            String otherNodeName = this._children.get(i).toString();
            if (nodeName.compareTo(otherNodeName) <= 0) continue;
            ++i;
            break;
        }
        this._children.add(i, node);
        this._treeModel.nodesWereInserted(this, new int[]{i});
    }

    private void removeNodes(int[] toRemoveIndices, List toRemove) {
        if (toRemove.size() > 0) {
            this._children.removeAll(toRemove);
            this._treeModel.nodesWereRemoved(this, toRemoveIndices, toRemove.toArray());
        }
    }
}

