/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import IceGridGUI.Application.TreeNode;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class ApplicationActions {
    private TreeNode _target;
    private Action[] _array = new Action[20];

    public Action get(int index) {
        return this._array[index];
    }

    public boolean[] setTarget(TreeNode target) {
        this._target = target;
        boolean[] availableActions = this._target == null ? new boolean[20] : this._target.getAvailableActions();
        for (int i = 0; i < this._array.length; ++i) {
            this._array[i].setEnabled(availableActions[i]);
        }
        return availableActions;
    }

    ApplicationActions(boolean popup) {
        int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._array[0] = new AbstractAction(popup ? "New adapter" : "Adapter"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newAdapter();
            }
        };
        this._array[1] = new AbstractAction(popup ? "New database environment" : "Database environment"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newDbEnv();
            }
        };
        this._array[2] = new AbstractAction(popup ? "New node" : "Node"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newNode();
            }
        };
        this._array[3] = new AbstractAction(popup ? "New property set" : "Property set"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newPropertySet();
            }
        };
        this._array[4] = new AbstractAction(popup ? "New replica group" : "Replica group"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newReplicaGroup();
            }
        };
        this._array[5] = new AbstractAction(popup ? "New server" : "Server"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newServer();
            }
        };
        this._array[6] = new AbstractAction(popup ? "New IceBox server" : "IceBox server"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newServerIceBox();
            }
        };
        this._array[7] = new AbstractAction(popup ? "New server from template" : "Server from template"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newServerFromTemplate();
            }
        };
        this._array[8] = new AbstractAction(popup ? "New service" : "Service"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newService();
            }
        };
        this._array[9] = new AbstractAction(popup ? "New service from template" : "Service from template"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newServiceFromTemplate();
            }
        };
        this._array[10] = new AbstractAction(popup ? "New Server template" : "Server template"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newTemplateServer();
            }
        };
        this._array[11] = new AbstractAction(popup ? "New IceBox server template" : "IceBox server template"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newTemplateServerIceBox();
            }
        };
        this._array[12] = new AbstractAction(popup ? "New service template" : "Service template"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.newTemplateService();
            }
        };
        this._array[13] = new AbstractAction("Copy"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.copy();
            }
        };
        this._array[13].putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, MENU_MASK));
        this._array[13].putValue("ShortDescription", "Copy");
        this._array[14] = new AbstractAction("Paste"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.paste();
            }
        };
        this._array[14].putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, MENU_MASK));
        this._array[14].putValue("ShortDescription", "Paste");
        this._array[15] = new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.delete();
            }
        };
        this._array[15].putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this._array[15].putValue("ShortDescription", "Delete");
        this._array[16] = new AbstractAction("Show variables"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.getCoordinator().showVars();
            }
        };
        this._array[16].putValue("ShortDescription", "Show variables and parameters in the Properties pane");
        this._array[17] = new AbstractAction("Substitute variables"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.getCoordinator().substituteVars();
            }
        };
        this._array[17].putValue("ShortDescription", "Substitute variables and parameters with their values in the Properties pane");
        this._array[18] = new AbstractAction("Move up"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.moveUp();
            }
        };
        this._array[19] = new AbstractAction("Move down"){

            public void actionPerformed(ActionEvent e) {
                ApplicationActions.this._target.moveDown();
            }
        };
    }
}

