/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.CommunicatorDescriptor;
import IceGrid.IceBoxDescriptor;
import IceGrid.ServerDescriptor;
import IceGrid.TemplateDescriptor;
import IceGridGUI.Application.Communicator;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.PlainServer;
import IceGridGUI.Application.ServerTemplateEditor;
import IceGridGUI.Application.ServerTemplates;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class ServerTemplate
extends Communicator {
    private TemplateDescriptor _templateDescriptor;
    private final boolean _ephemeral;
    private Editable _editable;
    private ServerTemplateEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static Icon _plainIcon;
    private static Icon _iceboxIcon;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static TemplateDescriptor copyDescriptor(TemplateDescriptor templateDescriptor) {
        TemplateDescriptor copy = (TemplateDescriptor)templateDescriptor.clone();
        copy.descriptor = PlainServer.copyDescriptor((ServerDescriptor)copy.descriptor);
        return copy;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _plainIcon = Utils.getIcon("/icons/16x16/server_template.png");
            _iceboxIcon = Utils.getIcon("/icons/16x16/icebox_server_template.png");
        }
        if (this._templateDescriptor.descriptor instanceof IceBoxDescriptor) {
            if (expanded) {
                _cellRenderer.setOpenIcon(_iceboxIcon);
            } else {
                _cellRenderer.setClosedIcon(_iceboxIcon);
            }
        } else if (expanded) {
            _cellRenderer.setOpenIcon(_plainIcon);
        } else {
            _cellRenderer.setClosedIcon(_plainIcon);
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = true;
        if (((TreeNode)this._parent).getAvailableActions()[14]) {
            actions[14] = true;
        }
        actions[15] = true;
        actions[0] = !this._services.initialized();
        actions[8] = this._services.initialized();
        actions[9] = this._services.initialized();
        actions[1] = this._dbEnvs.initialized();
        return actions;
    }

    public void copy() {
        this.getCoordinator().setClipboard(ServerTemplate.copyDescriptor(this._templateDescriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    public void paste() {
        ((TreeNode)this._parent).paste();
    }

    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(0));
            _popup.add(actions.get(1));
            _popup.add(actions.get(8));
            _popup.add(actions.get(9));
        }
        actions.setTarget(this);
        return _popup;
    }

    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (ServerTemplateEditor)this.getRoot().getEditor(ServerTemplateEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    protected Editor createEditor() {
        return new ServerTemplateEditor();
    }

    public void destroy() {
        ServerTemplates serverTemplates = (ServerTemplates)this._parent;
        if (this._ephemeral) {
            serverTemplates.removeChild(this);
        } else {
            serverTemplates.removeDescriptor(this._id);
            this.getRoot().removeServerInstances(this._id);
            serverTemplates.removeChild(this);
            serverTemplates.getEditable().removeElement(this._id, this._editable, ServerTemplate.class);
            this.getRoot().updated();
        }
    }

    public boolean isEphemeral() {
        return this._ephemeral;
    }

    public Object getDescriptor() {
        return this._templateDescriptor;
    }

    CommunicatorDescriptor getCommunicatorDescriptor() {
        return this._templateDescriptor.descriptor;
    }

    public Object saveDescriptor() {
        TemplateDescriptor clone = (TemplateDescriptor)this._templateDescriptor.clone();
        clone.descriptor = (ServerDescriptor)this._templateDescriptor.descriptor.clone();
        return clone;
    }

    public void restoreDescriptor(Object savedDescriptor) {
        TemplateDescriptor clone = (TemplateDescriptor)savedDescriptor;
        this._templateDescriptor.parameters = clone.parameters;
        PlainServer.shallowRestore((ServerDescriptor)clone.descriptor, (ServerDescriptor)this._templateDescriptor.descriptor);
    }

    ServerTemplate(boolean brandNew, ServerTemplates parent, String name, TemplateDescriptor descriptor) throws UpdateFailedException {
        super(parent, name);
        this._editable = new Editable(brandNew);
        this._ephemeral = false;
        this.rebuild(descriptor);
    }

    ServerTemplate(ServerTemplates parent, String name, TemplateDescriptor descriptor) {
        block2: {
            super(parent, name);
            this._ephemeral = true;
            try {
                this.rebuild(descriptor);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(ServerTemplate.createAttribute("id", this._id));
            writer.writeStartTag("server-template", attributes);
            ServerTemplate.writeParameters(writer, this._templateDescriptor.parameters, this._templateDescriptor.parameterDefaults);
            if (this._templateDescriptor.descriptor instanceof IceBoxDescriptor) {
                IceBoxDescriptor descriptor = (IceBoxDescriptor)this._templateDescriptor.descriptor;
                writer.writeStartTag("icebox", PlainServer.createAttributes(descriptor));
                if (descriptor.description.length() > 0) {
                    writer.writeElement("description", descriptor.description);
                }
                PlainServer.writeOptions(writer, descriptor.options);
                PlainServer.writeEnvs(writer, descriptor.envs);
                ServerTemplate.writePropertySet(writer, "", descriptor.propertySet, descriptor.adapters);
                ServerTemplate.writeDistribution(writer, descriptor.distrib);
                this._adapters.write(writer);
                this._services.write(writer);
                writer.writeEndTag("icebox");
            } else {
                ServerDescriptor descriptor = (ServerDescriptor)this._templateDescriptor.descriptor;
                writer.writeStartTag("server", PlainServer.createAttributes(descriptor));
                if (descriptor.description.length() > 0) {
                    writer.writeElement("description", descriptor.description);
                }
                PlainServer.writeOptions(writer, descriptor.options);
                PlainServer.writeEnvs(writer, descriptor.envs);
                ServerTemplate.writePropertySet(writer, "", descriptor.propertySet, descriptor.adapters);
                ServerTemplate.writeDistribution(writer, descriptor.distrib);
                this._adapters.write(writer);
                this._dbEnvs.write(writer);
                writer.writeEndTag("server");
            }
            writer.writeEndTag("server-template");
        }
    }

    boolean isIceBox() {
        return this._templateDescriptor.descriptor instanceof IceBoxDescriptor;
    }

    void rebuild(TemplateDescriptor descriptor) throws UpdateFailedException {
        this._templateDescriptor = descriptor;
        this._adapters.clear();
        this._dbEnvs.clear();
        this._services.clear();
        if (!this._ephemeral) {
            this._adapters.init(this._templateDescriptor.descriptor.adapters);
            if (this._templateDescriptor.descriptor instanceof IceBoxDescriptor) {
                IceBoxDescriptor iceBoxDescriptor = (IceBoxDescriptor)this._templateDescriptor.descriptor;
                this._services.init(iceBoxDescriptor.services);
                if (!$assertionsDisabled && this._templateDescriptor.descriptor.dbEnvs.size() != 0) {
                    throw new AssertionError();
                }
            } else {
                this._dbEnvs.init(this._templateDescriptor.descriptor.dbEnvs);
            }
        }
    }

    void rebuild() throws UpdateFailedException {
        this.rebuild(this._templateDescriptor);
    }

    void commit() {
        this._editable.commit();
    }

    Editable getEditable() {
        return this._editable;
    }

    Editable getEnclosingEditable() {
        return this._editable;
    }

    List findInstances() {
        return this.getRoot().findServerInstances(this._id);
    }

    static {
        $assertionsDisabled = !ServerTemplate.class.desiredAssertionStatus();
    }
}

