/**************************************************************************************************
	$Header: /pub/cvsroot/yencode/lib/screen.c,v 1.4 2002/03/10 16:22:19 bboy Exp $

	Copyright (C) 2002  Don Moore <bboy@bboy.net>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at Your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**************************************************************************************************/

#include "misc.h"

#ifndef TIOCGWINSZ
#include <sys/ioctl.h>
#endif


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	GET_SCREEN_WIDTH
	Returns the screen width.  Defaults if called from a non-terminal.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int
get_screen_width(void)
{
	struct winsize size;

	if (!isatty(STDIN_FILENO))
		return (0);
	if (ioctl(STDIN_FILENO, TIOCGWINSZ, (char *)&size) < 0)
		return (0);

	return (size.ws_col);
}
/*--- get_screen_width() ------------------------------------------------------------------------*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	CHARLINE
	Outputs a line of characters the width of the screen.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
inline void
charline(char c)
{
	int ct, width = get_screen_width();

	for (ct = 0; ct < width-1; ct++)
		putc(c, stdout);
	puts("");
}
/*--- charline() --------------------------------------------------------------------------------*/

/* vi:set ts=3: */
