/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import org.xml.sax.SAXException;

final class Tokenizer {
    private static final int UNKNOWN = -1;
    public static final int EOF = 0;
    public static final int NAME = 1;
    public static final int FUNCTION = 2;
    public static final int LITERAL = 3;
    public static final int VBAR = 4;
    public static final int SLASH = 5;
    public static final int AT = 6;
    public static final int LSQB = 7;
    public static final int RSQB = 8;
    public static final int LPAR = 9;
    public static final int RPAR = 10;
    public static final int EQUALS = 11;
    public static final int DOT = 12;
    public static final int DOTDOT = 13;
    public static final int STAR = 14;
    public static final int COMMA = 15;
    public static final int SLSL = 16;
    public static final int PREFIX = 17;
    public static final int OR = 18;
    public static final int AND = 19;
    public static final int NUMBER = 20;
    public static final int GT = 21;
    public static final int LT = 22;
    public static final int GE = 23;
    public static final int LE = 24;
    public static final int PLUS = 25;
    public static final int MINUS = 26;
    public static final int MULT = 27;
    public static final int DIV = 28;
    public static final int MOD = 29;
    public static final int DOLLAR = 31;
    public static final int NODETYPE = 32;
    public static final int AXIS = 33;
    public static final int NE = 34;
    public static final int NEGATE = 99;
    public static String[] tokens = new String[]{"EOF", "<name>", "<function>", "<literal>", "|", "/", "@", "[", "]", "(", ")", "=", ".", "..", "*", ",", "//", "^", "or", "and", "<number>", ">", "<", ">=", "<=", "+", "-", "*", "div", "mod", "--quo--", "$", "<nodetype>()", "<axis>()", "!="};
    public int currentToken = 0;
    public String currentTokenValue = null;
    public double currentNumericValue = 0.0;
    private int currentTokenStartIndex = 0;
    public String pattern;
    private int patternIndex = 0;
    private int patternLength;
    private int precedingToken = -1;

    Tokenizer() {
    }

    public void tokenize(String string) throws SAXException {
        this.currentToken = 0;
        this.currentTokenValue = null;
        this.currentTokenStartIndex = 0;
        this.patternIndex = 0;
        this.pattern = string;
        this.patternLength = string.length();
        this.next();
    }

    public void next() throws SAXException {
        char c;
        this.precedingToken = this.currentToken;
        this.currentTokenValue = null;
        this.currentTokenStartIndex = this.patternIndex;
        block35: while (true) {
            if (this.patternIndex >= this.patternLength) {
                this.currentToken = 0;
                return;
            }
            c = this.pattern.charAt(this.patternIndex++);
            switch (c) {
                case '/': {
                    if (this.patternIndex < this.patternLength && this.pattern.charAt(this.patternIndex) == '/') {
                        ++this.patternIndex;
                        this.currentToken = 16;
                        return;
                    }
                    this.currentToken = 5;
                    return;
                }
                case '@': {
                    this.currentToken = 6;
                    return;
                }
                case '[': {
                    this.currentToken = 7;
                    return;
                }
                case ']': {
                    this.currentToken = 8;
                    return;
                }
                case '(': {
                    this.currentToken = 9;
                    return;
                }
                case ')': {
                    this.currentToken = 10;
                    return;
                }
                case '+': {
                    this.currentToken = 25;
                    return;
                }
                case '-': {
                    this.currentToken = 26;
                    return;
                }
                case '=': {
                    this.currentToken = 11;
                    return;
                }
                case '!': {
                    if (this.patternIndex < this.patternLength && this.pattern.charAt(this.patternIndex) == '=') {
                        ++this.patternIndex;
                        this.currentToken = 34;
                        return;
                    }
                    throw new SAXException("\"!\" without \"=\" in expression " + this.pattern);
                }
                case '*': {
                    this.currentToken = this.precedingToken == 0 || this.precedingToken == 6 || this.precedingToken == 9 || this.precedingToken == 7 || this.precedingToken == 2 || this.precedingToken == 33 || Tokenizer.isOperator(this.precedingToken) ? 14 : 27;
                    return;
                }
                case ',': {
                    this.currentToken = 15;
                    return;
                }
                case '$': {
                    this.currentToken = 31;
                    return;
                }
                case '|': {
                    this.currentToken = 4;
                    return;
                }
                case '<': {
                    if (this.patternIndex < this.patternLength && this.pattern.charAt(this.patternIndex) == '=') {
                        ++this.patternIndex;
                        this.currentToken = 24;
                        return;
                    }
                    this.currentToken = 22;
                    return;
                }
                case '>': {
                    if (this.patternIndex < this.patternLength && this.pattern.charAt(this.patternIndex) == '=') {
                        ++this.patternIndex;
                        this.currentToken = 23;
                        return;
                    }
                    this.currentToken = 21;
                    return;
                }
                case '.': {
                    if (this.patternIndex < this.patternLength && this.pattern.charAt(this.patternIndex) == '.') {
                        ++this.patternIndex;
                        this.currentToken = 13;
                        return;
                    }
                    if (this.patternIndex == this.patternLength || this.pattern.charAt(this.patternIndex) < '0' || this.pattern.charAt(this.patternIndex) > '9') {
                        this.currentToken = 12;
                        return;
                    }
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    while (this.patternIndex < this.patternLength) {
                        c = this.pattern.charAt(this.patternIndex);
                        if (c != '.' && !Character.isDigit(c)) break;
                        ++this.patternIndex;
                    }
                    this.currentTokenValue = this.pattern.substring(this.currentTokenStartIndex, this.patternIndex);
                    try {
                        this.currentNumericValue = new Double(this.currentTokenValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXException("Invalid number (" + this.currentTokenValue + ") in expression " + this.pattern);
                    }
                    this.currentToken = 20;
                    return;
                }
                case '\"': 
                case '\'': {
                    this.patternIndex = this.pattern.indexOf(c, this.patternIndex);
                    if (this.patternIndex < 0) {
                        this.patternIndex = this.currentTokenStartIndex + 1;
                        throw new SAXException("Unmatched quote in expression " + this.pattern);
                    }
                    this.currentTokenValue = this.pattern.substring(this.currentTokenStartIndex + 1, this.patternIndex++).intern();
                    this.currentToken = 3;
                    return;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.currentTokenStartIndex = this.patternIndex;
                    continue block35;
                }
                default: {
                    if (c >= '\u0080' || Character.isLetter(c)) break block35;
                    throw new SAXException("Invalid character (" + c + ") in expression " + this.pattern);
                }
                case '_': 
            }
            break;
        }
        block37: while (this.patternIndex < this.patternLength) {
            c = this.pattern.charAt(this.patternIndex);
            switch (c) {
                case ':': {
                    if (this.patternIndex + 1 < this.patternLength && this.pattern.charAt(this.patternIndex + 1) == ':') {
                        this.currentTokenValue = this.pattern.substring(this.currentTokenStartIndex, this.patternIndex).intern();
                        this.currentToken = 33;
                        this.patternIndex += 2;
                        return;
                    }
                    if (this.patternIndex + 1 >= this.patternLength || this.pattern.charAt(this.patternIndex + 1) != '*') break;
                    this.currentTokenValue = this.pattern.substring(this.currentTokenStartIndex, this.patternIndex).intern();
                    this.currentToken = 17;
                    this.patternIndex += 2;
                    return;
                }
                case '-': 
                case '.': 
                case '_': {
                    break;
                }
                case '(': {
                    this.currentTokenValue = this.pattern.substring(this.currentTokenStartIndex, this.patternIndex).intern();
                    int n = Tokenizer.getBinaryOp(this.currentTokenValue);
                    if (n != -1) {
                        this.currentToken = n;
                        return;
                    }
                    ++this.patternIndex;
                    this.currentToken = Tokenizer.getFunctionType(this.currentTokenValue);
                    return;
                }
                default: {
                    if (c < '\u0080' && !Character.isLetterOrDigit(c)) break block37;
                }
            }
            ++this.patternIndex;
        }
        this.currentTokenValue = this.pattern.substring(this.currentTokenStartIndex, this.patternIndex).intern();
        int n = this.patternIndex;
        block38: while (n < this.patternLength) {
            switch (this.pattern.charAt(n)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case ':': {
                    if (n + 1 >= this.patternLength || this.pattern.charAt(n + 1) != ':') break;
                    this.currentToken = 33;
                    this.patternIndex = n + 2;
                    return;
                }
                case '(': {
                    int n2 = Tokenizer.getBinaryOp(this.currentTokenValue);
                    if (n2 != -1) {
                        this.currentToken = n2;
                        return;
                    }
                    this.currentToken = Tokenizer.getFunctionType(this.currentTokenValue);
                    this.patternIndex = n + 1;
                    return;
                }
                default: {
                    break block38;
                }
            }
            ++n;
        }
        int n3 = Tokenizer.getBinaryOp(this.currentTokenValue);
        this.currentToken = n3 != -1 && this.precedingToken != 0 && this.precedingToken != 6 && this.precedingToken != 9 && this.precedingToken != 7 && this.precedingToken != 2 && this.precedingToken != 33 && !Tokenizer.isOperator(this.precedingToken) ? n3 : 1;
    }

    private static int getBinaryOp(String string) {
        if (string == "and") {
            return 19;
        }
        if (string == "or") {
            return 18;
        }
        if (string == "div") {
            return 28;
        }
        if (string == "mod") {
            return 29;
        }
        return -1;
    }

    private static int getFunctionType(String string) {
        if (string == "node") {
            return 32;
        }
        if (string == "text") {
            return 32;
        }
        if (string == "comment") {
            return 32;
        }
        if (string == "processing-instruction") {
            return 32;
        }
        return 2;
    }

    private static boolean isOperator(int n) {
        return n == 5 || n == 16 || n == 4 || n == 11 || n == 18 || n == 19 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 28 || n == 29;
    }
}

