/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.LastPositionFinder;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.LookaheadEnumerator;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.Comparer;
import com.icl.saxon.sort.CompositeKey;
import com.icl.saxon.sort.MultiKeyComparer;
import com.icl.saxon.sort.QuickSort;
import com.icl.saxon.sort.SortKeyDefinition;
import java.util.Vector;
import org.xml.sax.SAXException;

public class SortKeyEnumeration
implements NodeEnumeration,
LastPositionFinder {
    protected NodeEnumeration base;
    private Vector sortkeys;
    private CompositeKey[] nodeKeys;
    private int count = -1;
    private int index = 0;
    private Context context;
    private MultiKeyComparer comparer;

    public SortKeyEnumeration(NodeEnumeration nodeEnumeration) throws SAXException {
        this.base = nodeEnumeration;
    }

    public void setSortKeys(Vector vector) throws SAXException {
        this.sortkeys = vector;
        if (!this.base.isSorted()) {
            Object object;
            boolean bl = false;
            int n = 0;
            while (n < this.sortkeys.size()) {
                object = (SortKeyDefinition)this.sortkeys.elementAt(n);
                Expression expression = ((SortKeyDefinition)object).getSortKey();
                if ((expression.getDependencies() & 0x30) != 0) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                object = new NodeSetExtent(this.base);
                ((NodeSetExtent)object).sort();
                this.base = ((NodeSetExtent)object).enumerate();
            }
        }
    }

    public void setComparer(MultiKeyComparer multiKeyComparer) {
        this.comparer = multiKeyComparer;
    }

    public Comparer getComparer() {
        return this.comparer;
    }

    public void setContext(Context context) {
        this.context = context == null ? new Context() : context.newContext();
    }

    public boolean hasMoreElements() throws SAXException {
        if (this.count < 0) {
            this.doSort();
        }
        return this.index < this.count;
    }

    public NodeInfo nextElement() {
        return this.nodeKeys[this.index++].getNode();
    }

    public boolean isSorted() {
        return true;
    }

    public boolean isReverseSorted() {
        return false;
    }

    public boolean isPeer() throws SAXException {
        return this.base.isPeer();
    }

    public int getLastPosition() throws SAXException {
        if (this.base instanceof LastPositionFinder && !(this.base instanceof LookaheadEnumerator)) {
            return ((LastPositionFinder)((Object)this.base)).getLastPosition();
        }
        if (this.count < 0) {
            this.doSort();
        }
        return this.count;
    }

    private void buildArray() throws SAXException {
        int n;
        if (this.base instanceof LastPositionFinder && !(this.base instanceof LookaheadEnumerator)) {
            n = ((LastPositionFinder)((Object)this.base)).getLastPosition();
            this.context.setLast(n);
        } else {
            n = 100;
            this.context.setLast(-1);
        }
        this.nodeKeys = new CompositeKey[n];
        this.count = 0;
        while (this.base.hasMoreElements()) {
            NodeInfo nodeInfo = this.base.nextElement();
            if (this.count == n) {
                CompositeKey[] compositeKeyArray = new CompositeKey[n *= 2];
                System.arraycopy(this.nodeKeys, 0, compositeKeyArray, 0, this.count);
                this.nodeKeys = compositeKeyArray;
            }
            this.context.setCurrentNode(nodeInfo);
            this.context.setContextNode(nodeInfo);
            this.context.setPosition(this.count + 1);
            this.nodeKeys[this.count] = new CompositeKey(this.sortkeys, nodeInfo, this.context);
            ++this.count;
        }
    }

    private void doSort() throws SAXException {
        this.buildArray();
        if (this.count < 2) {
            return;
        }
        QuickSort quickSort = new QuickSort(this.comparer);
        quickSort.sort(this.nodeKeys, this.count);
    }
}

