/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.DummyStaticContext;
import com.icl.saxon.expr.ErrorExpression;
import com.icl.saxon.expr.ExpressionParser;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.Value;
import java.util.Vector;
import org.xml.sax.SAXException;

public abstract class Expression {
    protected StaticContext staticContext;
    protected static Vector emptyVector = new Vector();

    public static Expression make(String string, StaticContext staticContext) throws SAXException {
        try {
            Expression expression = new ExpressionParser().parse(string, staticContext).simplify();
            expression.staticContext = staticContext;
            return expression;
        }
        catch (SAXException sAXException) {
            if (staticContext.forwardsCompatibleModeIsEnabled()) {
                return new ErrorExpression(sAXException);
            }
            throw sAXException;
        }
    }

    public static Expression make(String string) throws SAXException {
        return Expression.make(string, new DummyStaticContext());
    }

    public Expression simplify() throws SAXException {
        return this;
    }

    public final void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public final StaticContext getStaticContext() {
        return this.staticContext;
    }

    public boolean containsReferences() throws SAXException {
        return (this.getDependencies() & 1) != 0;
    }

    public abstract Value evaluate(Context var1) throws SAXException;

    public boolean evaluateAsBoolean(Context context) throws SAXException {
        return this.evaluate(context).asBoolean();
    }

    public double evaluateAsNumber(Context context) throws SAXException {
        return this.evaluate(context).asNumber();
    }

    public String evaluateAsString(Context context) throws SAXException {
        return this.evaluate(context).asString();
    }

    public NodeSetValue evaluateAsNodeSet(Context context) throws SAXException {
        Value value = this.evaluate(context);
        if (value instanceof NodeSetValue) {
            return (NodeSetValue)value;
        }
        throw new SAXException("Cannot convert value [" + value.toString() + "] to a node-set");
    }

    public NodeEnumeration enumerate(Context context) throws SAXException {
        Value value = this.evaluate(context);
        if (value instanceof NodeSetValue) {
            return ((NodeSetValue)value).enumerate();
        }
        throw new SAXException("Cannot convert value [" + value.toString() + "] to a node-set");
    }

    public int getDataType() {
        return -1;
    }

    public boolean isNumeric() {
        return this.getDataType() == 2;
    }

    public final boolean isRelative() throws SAXException {
        return (this.getDependencies() & 0x30) != 0;
    }

    public boolean usesCurrent() throws SAXException {
        return (this.getDependencies() & 4) != 0;
    }

    public abstract int getDependencies();

    public abstract Expression reduce(int var1, Context var2) throws SAXException;
}

