var webdeveloper_editHTMLIntervalId      = null;
var webdeveloper_editHTMLSelectedTab     = 0;
var webdeveloper_editHTMLUpdateFrequency = 500;

// Applies the HTML
function webdeveloper_applyHTML()
{
    var contentBody = webdeveloper_getContentDocument().body;
    var newHTML     = document.getElementById("webdeveloper-edit-html-text-box").value;

    // If the content body is set and the new HTML is not the same as the previous HTML
    if(contentBody && newHTML != contentBody.innerHTML)
    {
        contentBody.innerHTML = newHTML;
    }
}

// Clear the HTML
function webdeveloper_clearHTML()
{
    document.getElementById("webdeveloper-edit-html-text-box").value = "";
}

// Reinitializes the sidebar when the page changes
function webdeveloper_editHTMLContentPageLoad(event)
{
    var eventTarget    = event.target;
    var originalTarget = event.originalTarget;

    // If the page is the target and the URI matches
    if(originalTarget && eventTarget && eventTarget.contentDocument && eventTarget.hasAttribute && eventTarget.hasAttribute("id") && eventTarget.getAttribute("id").toLowerCase() == "content" && originalTarget.documentURI == eventTarget.contentDocument.documentURI)
    {
        // If the page is generated
        if(originalTarget.documentURI == "about:blank")
        {
            window.clearInterval(webdeveloper_editHTMLIntervalId);
            window.setTimeout(webdeveloper_retrieveHTML, 1000);
            window.setTimeout(webdeveloper_updateHTML, 1000);
        }
        else
        {
            webdeveloper_retrieveHTML();
        }
    }
}

// Handles a browser tab being selected
function webdeveloper_editHTMLMainTabSelect(event)
{
    var browser     = window.top.getBrowser();
    var selectedTab = browser.mTabBox.selectedIndex;

    // If the selected tab is different
    if(selectedTab != webdeveloper_editHTMLSelectedTab)
    {
        browser.browsers[webdeveloper_editHTMLSelectedTab].contentDocument.location.reload(false);

        webdeveloper_editHTMLSelectedTab = selectedTab;

        webdeveloper_retrieveHTML();
    }
}

// Initializes the edit HTML sidebar
function webdeveloper_initializeEditHTML()
{
    var browser      = window.top.getBrowser();
    var mainTabBox   = browser.mTabBox;
    var textBox      = document.getElementById("webdeveloper-edit-html-text-box");
    var textBoxStyle = "";

    webdeveloper_editHTMLSelectedTab     = mainTabBox.selectedIndex;
    webdeveloper_editHTMLUpdateFrequency = webdeveloper_getIntegerPreference("webdeveloper.edit.update.frequency", true);

    mainTabBox.addEventListener("select", webdeveloper_editHTMLMainTabSelect, true);
    window.top.addEventListener("load", webdeveloper_editHTMLContentPageLoad, true);

    // If the edit CSS background color preference is set
    if(webdeveloper_isPreferenceSet("webdeveloper.edit.color.background"))
    {
        textBoxStyle += "background-color: " + webdeveloper_getStringPreference("webdeveloper.edit.color.background", true) + " !important; ";
    }

    // If the edit CSS text color preference is set
    if(webdeveloper_isPreferenceSet("webdeveloper.edit.color.text"))
    {
        textBoxStyle += "color: " + webdeveloper_getStringPreference("webdeveloper.edit.color.text", true) + " !important; ";
    }

    // If the edit CSS font preference is set
    if(webdeveloper_isPreferenceSet("webdeveloper.edit.font.size"))
    {
        textBoxStyle += "font-size: " + webdeveloper_getIntegerPreference("webdeveloper.edit.font.size", true) + "px !important; ";
    }

    textBox.setAttribute("style", textBoxStyle.trim());

    webdeveloper_retrieveHTML();
    webdeveloper_updateHTML();
}

// Resets the edited HTML
function webdeveloper_resetHTML()
{
    window.top.BrowserReloadSkipCache();
}

// Retrieves the HTML
function webdeveloper_retrieveHTML()
{
    var contentBody = webdeveloper_getContentDocument().body;
    var textBox     = document.getElementById("webdeveloper-edit-html-text-box");

    // If the content body is set
    if(contentBody)
    {
        textBox.value = contentBody.innerHTML;
    }

    webdeveloper_applyHTML();
}

// Saves the HTML
function webdeveloper_saveHTML()
{
    var contentDocument = webdeveloper_getContentDocument();
    var filePicker      = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
    var result          = null;
    var stringBundle    = document.getElementById("webdeveloper-string-bundle");
    var url             = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURL);

    url.spec                    = contentDocument.documentURI;
    filePicker.defaultExtension = url.fileExtension;
    filePicker.defaultString    = url.fileName;

    filePicker.init(window, stringBundle.getString("webdeveloper_saveHTML"), filePicker.modeSave);

    result = filePicker.show();

    // If the user selected a file
    if(result == filePicker.returnOK || result == filePicker.returnReplace)
    {
        var file                       = filePicker.file;
        var webBrowserPersistInterface = Components.interfaces.nsIWebBrowserPersist;
        var webBrowserPersist          = Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"].createInstance(webBrowserPersistInterface);

        webBrowserPersist.persistFlags = webBrowserPersistInterface.PERSIST_FLAGS_AUTODETECT_APPLY_CONVERSION | webBrowserPersistInterface.PERSIST_FLAGS_FROM_CACHE | webBrowserPersistInterface.PERSIST_FLAGS_REPLACE_EXISTING_FILES;

        // If the file does not exist
        if(!file.exists())
        {
            file.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 00644);
        }

        webBrowserPersist.saveDocument(contentDocument, file, null, contentDocument.contentType, webBrowserPersistInterface.ENCODE_FLAGS_ENCODE_BASIC_ENTITIES, 0);
    }
}

// Unloads edit HTML
function webdeveloper_unloadEditHTML()
{
    var browser    = window.top.getBrowser();
    var mainTabBox = browser.mTabBox;

    window.clearInterval(webdeveloper_editHTMLIntervalId);

    // Try to remove the event listener
    try
    {
        mainTabBox.removeEventListener("select", webdeveloper_editHTMLMainTabSelect, true);
    }
    catch(exception)
    {
        // Do nothing
    }

    // Try to remove the event listener
    try
    {
        window.top.removeEventListener("load", webdeveloper_editHTMLContentPageLoad, true);
    }
    catch(exception)
    {
        // Do nothing
    }

    window.top.BrowserReloadSkipCache();
}

// Updates the HTML
function webdeveloper_updateHTML()
{
    // If the update frequency is greater than 0
    if(webdeveloper_editHTMLUpdateFrequency > 0)
    {
        webdeveloper_editHTMLIntervalId = window.setInterval(webdeveloper_applyHTML, webdeveloper_editHTMLUpdateFrequency);
    }
}