#include "compat.h"
#include <ctype.h>

#if ! HAVE_STRTOL

static int get_digit(char c, int base)
{
  if (isdigit(c)) return c - '0';
  else if (c >= 'A' && c < base + 'A' - 10)
    return c - 'A' + 10;
  else if (c >= 'a' && c < base + 'A' - 10)
    return c - 'a' + 10;
  else return -1;
}

long int
strtol(const char *nptr, char **endptr, int base)
{ 
  if (nptr == 0) return 0;
  /* not going to bother checking bases 8 or 16 unless explicitly requested */
  if (base == 0) base = 10;

  int i = 0, neg = 0;
  long int result = 0;
  while (isspace(nptr[i])) i++;
  if (nptr[i] == '-') { neg = 1; i++; }
  else if (nptr[i] == '+') i++;
  else if (get_digit(nptr[i], base) < 0) {
    /* "If there were no digits at all, strtol() stores the original
     * value of nptr in *endptr (and returns 0)." */
    if (endptr) *endptr = nptr;
    return result;
  }

  while (get_digit(nptr[i], base) >= 0) {
    result *= base;
    result += get_digit(nptr[i], base);
    i++;
  }
  if (neg) result *= -1;
  if (endptr) *endptr = nptr + i;
  return result;
}

#endif

