/*
 * BRLTTY - Access software for Unix for a blind person
 *          using a soft Braille terminal
 *
 * Version 0.22 BETA, 22 September 1995
 *
 * Copyright (C) 1995 by Nikhil Nair & James Bowden.  All rights reserved.
 * BRLTTY comes with ABSOLUTELY NO WARRANTY.
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
 *
 * This software is maintained by Nikhil Nair <nn201@cam.ac.uk>.
 */

#ifndef __SCR_h
#define __SCR_H

#ifdef __cplusplus
extern "C"
{
#endif

#if defined (__JABT) || defined (__SCREADER)
#	define VCS_FILE	"/dev/vcsa0"
#endif
#define SCR_TEXT	0
#define SCR_ATTRIB	1

typedef struct
{
  short rows, cols;		/* screen dimentions */
  short posx, posy;		/* cursor position */
} scrstat;

/* Functions provided by this library */
int my_initscr (void);		/* initialise screen reading functions */
scrstat getstat (void);		/* get screen status */
char *getscr (int, int, int, int, char *, int);	/* read a rectangle from */
				/* the screen - text or attributes */
void closescr (void);		/* close screen reading */

extern void play_sample (char *, int);

#ifdef __cplusplus
}
#endif
#endif
