require 'runit/testcase'
require 'runit/cui/testrunner'
require 'runit/topublic'

class ClassToPublic
  include RUNIT::ToPublic
  def to_public_public(klass)
    to_public(klass)
  end
end

class Dummy
  def private_foo
  end
  private :private_foo

  def protected_bar
  end
  protected :protected_bar

  def Dummy.to_private
    private :private_foo
  end

  def Dummy.to_protected
    protected :protected_bar
  end
end

module MDummy
  def private_m_method
  end
  private :private_m_method
end

class DummyChild
  include MDummy
end

class TestToPublic < RUNIT::TestCase
  def setup
    @to_pub = ClassToPublic.new
  end

  def test_to_public
    methods = Dummy.private_instance_methods
    assert(methods.include?('private_foo'))
    k = @to_pub.to_public_public(Dummy)

    assert_equal('Dummy', k.superclass.name)
    methods = k.public_instance_methods
    assert(methods.include?('private_foo'))
    assert(methods.include?('protected_bar'))

    methods = Dummy.private_instance_methods
    assert(methods.include?('private_foo'))
    methods = Dummy.protected_instance_methods
    assert(methods.include?('protected_bar'))
  end

  def test_s_to_public
    methods = Dummy.private_instance_methods
    assert(methods.include?('private_foo'))
    k = RUNIT::ToPublic.to_public(Dummy)

    assert_equal('Dummy', k.superclass.name)
    methods = k.public_instance_methods
    assert(methods.include?('private_foo'))
    assert(methods.include?('protected_bar'))

    private_methods = DummyChild.private_instance_methods(true)
    assert(private_methods.include?('private_m_method'))
    k = RUNIT::ToPublic.to_public(DummyChild)
    public_methods = k.public_instance_methods(true)
    assert(public_methods.include?('private_m_method'))
  end

  def teardown
    Dummy.to_private
    Dummy.to_protected
  end
end

if $0 == __FILE__
  RUNIT::CUI::TestRunner.run(TestToPublic.suite)
end
