require 'rubyunit'
require 'find'

require 'makehtml'

=begin
Unit test of RD2HTML class
=end

class TestRD2HTML < RUNIT::TestCase
  def setup
    @cur_dir = Dir.pwd
    @rd2html = RD2HTML.new('doc_en')
  end

  def test_out_file
    assert_equal('testcase', @rd2html.out_file('testcase.rd'))
  end

  def test_cmd_rd2html
    assert_equal('rd2 -otestcase testcase.rd',
                 @rd2html.cmd_rd2html('testcase.rd'))
  end

  def test_create
    @rd2html.create('testcase.rd')
    assert(File.exist?('testcase.html'))
    assert(File.file?('testcase.html'))
  end

  def teardown
    Dir.chdir(@cur_dir)
    Find.find('doc_en') do |f|
      if /\.html/ =~ f || /\.rmi/ =~ f
	File.unlink(f)
      end
    end
  end
end

