require 'parsearg'
require 'runit/testsuite'
require 'runit/cui/testrunner'

require 'testarray'
require 'simpletest'

class TestAll 
  def TestAll.suite
    suite = RUNIT::TestSuite.new
    suite.add(TestArray.suite) 
    suite.add(SimpleTest.suite)
    suite
  end
end

def usage
  print <<USAGE
#{File.basename($0)} [-wh] [(TestCase class names)...]
RubyUnit #{RUNIT::VERSION} sample script

example1. Run all tests.
  #{File.basename($0)}

example2. Run SimpleTest only.
  #{File.basename($0)} SimpleTest

example3. Run SimpleTest, and wait to enter <RETURN>, and run TestArray.
  #{File.basename($0)} -w SimpleTest TestArray

USAGE
end

if $0 == __FILE__
$USAGE = 'usage'
parseArgs(0, nil, "w")
puts RUNIT::VERSION

if ARGV.size == 0
  RUNIT::CUI::TestRunner.run(TestAll.suite)
else
  tr = RUNIT::CUI::TestRunner.new(STDERR, $OPT_w)
  ARGV.each do |t|
    k = eval(t)
    tr.run(k.suite)
  end
end
end
