/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
/* $Id: read_in_data.c,v 1.5 1999/02/28 01:58:50 lance Exp $ */
#include <stdio.h>
#include <assert.h>
#include "data.h"

extern int read_ascii_file(FILE *fileptr, char *file, Plot *plot);
extern int read_binary_file(FILE *fileptr, char *file, Plot *plot);
extern int check_for_stdin(void);
extern void usage(const char *argv0, FILE *fileptr);

static void error_exit(char *file)
{
  fprintf(stderr,
	  "quickplot ERROR: Having trouble interpeting file %s\n",
	  file);
  exit(1);
}
  
void read_in_data(Plot *plot, int argc, const char *argv0)/* open the files */
{
  int i;
  static FILE *fileptr;

  for(i=0;plot->infiles[i] != NULL;i++)
    {
      if(NULL == (fileptr = fopen(plot->infiles[i],"r")))
	{
	  fprintf(stderr,"quickplot ERROR: can't open file: %s\n",
		  plot->infiles[i]);
	  exit(1);
	}
      if(plot->flag & BINARY_DATA)
	{
	  if(read_binary_file(fileptr, plot->infiles[i], plot))
	    error_exit(plot->infiles[i]);
	}
      else
	if(read_ascii_file(fileptr, plot->infiles[i], plot))
	  error_exit(plot->infiles[i]);
      fclose(fileptr);
    }

  if((!(plot->flag & NO_PIPE_IN)) && (plot->flag & PIPE_IN || (i = check_for_stdin())
     || argc<2 ||(plot->infiles[0] == NULL))
     )
    {
        if( !(plot->flag & PIPE_IN) && !i)
	  {
	    usage(argv0,stderr);
	    if(plot->flag & BINARY_DATA)
	      fprintf(stderr,"quickplot Info: No input file given."
		      " Reading in binary data from standard input.\n=>");
	    else
	      fprintf(stderr,"quickplot Info: No input file given."
		      " Reading in ASCII data from standard input.\n=>");
	    fflush(stderr);
	  }
	
      if(plot->flag & BINARY_DATA)
	{
	  if(read_binary_file(stdin,"PIPE STDIN", plot))
	    error_exit("PIPE STDIN");
	}
      else
	{
	  if(read_ascii_file(stdin,"PIPE STDIN", plot))
	    error_exit("PIPE STDIN");
	}
    }

  if(plot->dim == 0)
    {
      fprintf(stderr,"quickplot ERROR: I've got no data to plot."
	      " Where is the data?\n");
      exit(1);
    }
}



