

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: String.i,v 1.6 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_string_i
#define quantlib_string_i

%{
typedef std::string String;
%}

%typemap(ruby,in) String, const String & {
    if (TYPE($source) == T_STRING)
        $target = new std::string(STR2CSTR($source));
    else
        rb_raise(rb_eTypeError, "not a string");
};

%typemap(ruby,freearg) String, const String & {
    delete $source;
};

%typemap(ruby,out) String, const String & {
    $target = rb_str_new2($source->c_str());
};

%typemap(ruby,ret) String, const String & {
    delete $source;
};


#endif
