
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: QLArray.i,v 1.15 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_array_i
#define quantlib_array_i

%include Types.i
%include String.i

%{
using QuantLib::Array;
typedef QuantLib::Math::LexicographicalView<Array::iterator>
    LexicographicalView;
typedef QuantLib::Math::LexicographicalView<Array::iterator>::y_iterator
    LexicographicalViewColumn;
%}

// array as python shadow class

%typemap(python,in) Array (Array temp), Array * (Array temp),
  const Array & (Array temp), Array & (Array temp) {
    Array* v;
    if (PyTuple_Check($source) || PyList_Check($source)) {
        int size = (PyTuple_Check($source) ?
            PyTuple_Size($source) :
            PyList_Size($source));
        temp = Array(size);
        $target = &temp;
        for (int i=0; i<size; i++) {
            PyObject* o = PySequence_GetItem($source,i);
            if (PyFloat_Check(o)) {
                (*$target)[i] = PyFloat_AsDouble(o);
                Py_DECREF(o);
            } else if (PyInt_Check(o)) {
                (*$target)[i] = double(PyInt_AsLong(o));
                Py_DECREF(o);
            } else {
                PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                Py_DECREF(o);
                return NULL;
            }
        }
    } else if ((SWIG_ConvertPtr($source,(void **) &v,
                                SWIGTYPE_p_Array,0)) != -1) {
        $target = v;
    } else {
        PyErr_SetString(PyExc_TypeError,"Array expected");
        return NULL;
    }
};

class Array {
  public:
    ~Array();
};

%addmethods Array {
    Array(const Array& a) {
        return new Array(a);
    }
    String __str__() {
        String s = "(";
        /* Size */ int size_ = self->size();
        if (size_>0) {
            for (/* Size */ int i=0; i<size_-1; i++) {
                s += DoubleFormatter::toString((*self)[i]);
                s += ", ";
            }
            s += DoubleFormatter::toString((*self)[size_-1]);
        }
        s += ")";
        return s;
    }
    int __len__() {
        return self->size();
    }
    double __getitem__(int i) {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            return (*self)[i];
        } else if (i<0 && -i<=size_) {
            return (*self)[size_+i];
        } else {
            throw IndexError("Array index out of range");
        }
        QL_DUMMY_RETURN(0.0)
    }
    void __setitem__(int i, double x) {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            (*self)[i] = x;
        } else if (i<0 && -i<=size_) {
            (*self)[size_+i] = x;
        } else {
            throw IndexError("Array index out of range");
        }
    }
    Array __getslice__(int i, int j) {
        int size_ = static_cast<int>(self->size());
        if (i<0)
            i = size_+i;
        if (j<0)
            j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        Array tmp(j-i);
        std::copy(self->begin()+i,self->begin()+j,tmp.begin());
        return tmp;
    }
    void __setslice__(int i, int j, const Array& rhs) {
        int size_ = static_cast<int>(self->size());
        if (i<0)
            i = size_+i;
        if (j<0)
            j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        QL_ENSURE(static_cast<int>(rhs.size()) == j-i,
            "Arrays are not resizable");
        std::copy(rhs.begin(),rhs.end(),self->begin()+i);
    }
    bool __nonzero__() {
        return (self->size() != 0);
    }
};





// 2-D view

class LexicographicalViewColumn {
  private:
    // access control - no constructor exported
    LexicographicalViewColumn();
  public:
    ~LexicographicalViewColumn();
};

%addmethods LexicographicalViewColumn {
    double __getitem__(int i) {
        return (*self)[i];
    }
    void __setitem__(int i, double x) {
        (*self)[i] = x;
    }
};


class LexicographicalView {
  public:
    ~LexicographicalView();
    int xSize() const;
    int ySize() const;
};

%addmethods LexicographicalView {
    LexicographicalView(Array& a, int xSize) {
        return new LexicographicalView(a.begin(),a.end(),xSize);
    }
    LexicographicalViewColumn __getitem__(int i) {
        return (*self)[i];
    }
    String __str__() {
        String s;
        for (int j=0; j<static_cast<int>(self->ySize()); j++) {
    	    s += "\n";
            for (int i=0; i<static_cast<int>(self->xSize()); i++) {
                if (i != 0)
                    s += ",";
                s += QuantLib::DoubleFormatter::toString((*self)[i][j]);
            }
        }
        s += "\n";
        return s;
    }
};


#endif
