// C++ interface wrapper code.
//
// Generated by SIP v2.5 on Fri Aug 10 18:47:41 2001
//
// Terms and Conditions
// 
// Copyright (c) 1998, 1999, 2000, 2001
// 	Phil Thompson <phil@river-bank.demon.co.uk>
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
// IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// 
// Except as contained in this notice, the name of the copyright holder shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from the
// copyright holder.

#include "sipqtDeclqt.h"
#include "sipqtQString.h"


PyObject *sipClass_QString;

static void sipDealloc_QString(sipThisType *);
static PyObject * sip__str__QString(PyObject *a0);

static PyTypeObject sipType_QString = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	sipName_qt_QString,
	sizeof (sipThisType),
	0,
	(destructor)sipDealloc_QString,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	sip__str__QString,
	0,
	0,
	0,
	Py_TPFLAGS_DEFAULT,
	0,
	0,
	0,
};

static PyObject *sipDo_QString_isNull(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::isNull();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_isNull);

	return NULL;
}

static PyObject *sipDo_QString_isEmpty(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::isEmpty();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_isEmpty);

	return NULL;
}

static PyObject *sipDo_QString_length(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			unsigned res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::length();

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_length);

	return NULL;
}

static PyObject *sipDo_QString_truncate(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		unsigned a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			ptr -> QString::truncate( a0);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_truncate);

	return NULL;
}

static PyObject *sipDo_QString_fill(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		QChar * a0;
		PyObject *a0obj;
		int a1 = -1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|i",sipCanConvertTo_QChar,&a0obj,&a1))
		{
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QChar(a0obj,&a0,1,&iserr);

			if (iserr)
				return NULL;

			ptr -> QString::fill(* a0, a1);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_fill);

	return NULL;
}

static PyObject *sipDo_QString_copy(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QString(ptr -> QString::copy());

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_copy);

	return NULL;
}

static PyObject *sipDo_QString_arg(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		int a0;
		int a1 = 0;
		int a2 = 10;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"C|ii",&a0,&a1,&a2))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QString(ptr -> QString::arg( a0, a1, a2));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	{
		char a0;
		int a1 = 0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"c|i",&a0,&a1))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QString(ptr -> QString::arg( a0, a1));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	{
		QChar * a0;
		PyObject *a0obj;
		int a1 = 0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|i",sipCanConvertTo_QChar,&a0obj,&a1))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QChar(a0obj,&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = new QString(ptr -> QString::arg(* a0, a1));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	{
		const QString * a0;
		PyObject *a0obj;
		int a1 = 0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|i",sipCanConvertTo_QString,&a0obj,&a1))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			int istemp0 = sipConvertTo_QString(a0obj,(QString **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = new QString(ptr -> QString::arg(* a0, a1));

			if (istemp0)
				delete a0;

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	{
		double a0;
		int a1 = 0;
		char a2 = 'g';
		int a3 = -1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"d|ici",&a0,&a1,&a2,&a3))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QString(ptr -> QString::arg( a0, a1, a2, a3));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_arg);

	return NULL;
}

static PyObject *sipDo_QString_find(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		QChar * a0;
		PyObject *a0obj;
		int a1 = 0;
		long a2 = 1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|il",sipCanConvertTo_QChar,&a0obj,&a1,&a2))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QChar(a0obj,&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QString::find(* a0, a1, (bool)a2);

			return PyInt_FromLong((long)res);
		}
	}

	{
		char a0;
		int a1 = 0;
		long a2 = 1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"c|il",&a0,&a1,&a2))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::find( a0, a1, (bool)a2);

			return PyInt_FromLong((long)res);
		}
	}

	{
		const QString * a0;
		PyObject *a0obj;
		int a1 = 0;
		long a2 = 1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|il",sipCanConvertTo_QString,&a0obj,&a1,&a2))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			int istemp0 = sipConvertTo_QString(a0obj,(QString **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QString::find(* a0, a1, (bool)a2);

			if (istemp0)
				delete a0;

			return PyInt_FromLong((long)res);
		}
	}

	{
		const QRegExp * a0;
		PyObject *a0obj;
		int a1 = 0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|i",sipCanConvertTo_QRegExp,&a0obj,&a1))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QRegExp(a0obj,(QRegExp **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QString::find(* a0, a1);

			return PyInt_FromLong((long)res);
		}
	}

	{
		const char * a0;
		int a1 = 0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"s|i",&a0,&a1))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::find( a0, a1);

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_find);

	return NULL;
}

static PyObject *sipDo_QString_findRev(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		QChar * a0;
		PyObject *a0obj;
		int a1 = -1;
		long a2 = 1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|il",sipCanConvertTo_QChar,&a0obj,&a1,&a2))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QChar(a0obj,&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QString::findRev(* a0, a1, (bool)a2);

			return PyInt_FromLong((long)res);
		}
	}

	{
		char a0;
		int a1 = -1;
		long a2 = 1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"c|il",&a0,&a1,&a2))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::findRev( a0, a1, (bool)a2);

			return PyInt_FromLong((long)res);
		}
	}

	{
		const QString * a0;
		PyObject *a0obj;
		int a1 = -1;
		long a2 = 1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|il",sipCanConvertTo_QString,&a0obj,&a1,&a2))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			int istemp0 = sipConvertTo_QString(a0obj,(QString **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QString::findRev(* a0, a1, (bool)a2);

			if (istemp0)
				delete a0;

			return PyInt_FromLong((long)res);
		}
	}

	{
		const QRegExp * a0;
		PyObject *a0obj;
		int a1 = -1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|i",sipCanConvertTo_QRegExp,&a0obj,&a1))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QRegExp(a0obj,(QRegExp **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QString::findRev(* a0, a1);

			return PyInt_FromLong((long)res);
		}
	}

	{
		const char * a0;
		int a1 = -1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"s|i",&a0,&a1))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::findRev( a0, a1);

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_findRev);

	return NULL;
}

static PyObject *sipDo_QString_contains(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		QChar * a0;
		PyObject *a0obj;
		long a1 = 1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|l",sipCanConvertTo_QChar,&a0obj,&a1))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QChar(a0obj,&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QString::contains(* a0, (bool)a1);

			return PyInt_FromLong((long)res);
		}
	}

	{
		char a0;
		long a1 = 1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"c|l",&a0,&a1))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::contains( a0, (bool)a1);

			return PyInt_FromLong((long)res);
		}
	}

	{
		const char * a0;
		long a1 = 1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"s|l",&a0,&a1))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::contains( a0, (bool)a1);

			return PyInt_FromLong((long)res);
		}
	}

	{
		const QString * a0;
		PyObject *a0obj;
		long a1 = 1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I|l",sipCanConvertTo_QString,&a0obj,&a1))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			int istemp0 = sipConvertTo_QString(a0obj,(QString **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QString::contains(* a0, (bool)a1);

			if (istemp0)
				delete a0;

			return PyInt_FromLong((long)res);
		}
	}

	{
		const QRegExp * a0;
		PyObject *a0obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I",sipCanConvertTo_QRegExp,&a0obj))
		{
			int res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QRegExp(a0obj,(QRegExp **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QString::contains(* a0);

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_contains);

	return NULL;
}

static PyObject *sipDo_QString_left(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		unsigned a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QString(ptr -> QString::left( a0));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_left);

	return NULL;
}

static PyObject *sipDo_QString_right(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		unsigned a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QString(ptr -> QString::right( a0));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_right);

	return NULL;
}

static PyObject *sipDo_QString_mid(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		unsigned a0;
		unsigned a1 = 2147483647;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i|i",&a0,&a1))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QString(ptr -> QString::mid( a0, a1));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_mid);

	return NULL;
}

static PyObject *sipDo_QString_leftJustify(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		unsigned a0;
		QChar * a1 = NULL;
		PyObject *a1obj = NULL;
		long a2 = 0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i|Il",&a0,sipCanConvertTo_QChar,&a1obj,&a2))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QChar(a1obj,&a1,1,&iserr);

			if (iserr)
				return NULL;

			res = new QString(ptr -> QString::leftJustify( a0,* a1, (bool)a2));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_leftJustify);

	return NULL;
}

static PyObject *sipDo_QString_rightJustify(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		unsigned a0;
		QChar * a1 = NULL;
		PyObject *a1obj = NULL;
		long a2 = 0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i|Il",&a0,sipCanConvertTo_QChar,&a1obj,&a2))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QChar(a1obj,&a1,1,&iserr);

			if (iserr)
				return NULL;

			res = new QString(ptr -> QString::rightJustify( a0,* a1, (bool)a2));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_rightJustify);

	return NULL;
}

static PyObject *sipDo_QString_lower(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QString(ptr -> QString::lower());

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_lower);

	return NULL;
}

static PyObject *sipDo_QString_upper(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QString(ptr -> QString::upper());

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_upper);

	return NULL;
}

static PyObject *sipDo_QString_stripWhiteSpace(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QString(ptr -> QString::stripWhiteSpace());

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_stripWhiteSpace);

	return NULL;
}

static PyObject *sipDo_QString_simplifyWhiteSpace(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QString(ptr -> QString::simplifyWhiteSpace());

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_simplifyWhiteSpace);

	return NULL;
}

static PyObject *sipDo_QString_insert(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		unsigned a0;
		const QString * a1;
		PyObject *a1obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"iI",&a0,sipCanConvertTo_QString,&a1obj))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			int istemp1 = sipConvertTo_QString(a1obj,(QString **)&a1,1,&iserr);

			if (iserr)
				return NULL;

			res = &ptr -> QString::insert( a0,* a1);

			if (istemp1)
				delete a1;

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	{
		unsigned a0;
		QChar * a1;
		PyObject *a1obj;
		unsigned a2;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"iIi",&a0,sipCanConvertTo_QChar,&a1obj,&a2))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QChar(a1obj,&a1,0,&iserr);

			if (iserr)
				return NULL;

			res = &ptr -> QString::insert( a0, a1, a2);

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	{
		unsigned a0;
		QChar * a1;
		PyObject *a1obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"iI",&a0,sipCanConvertTo_QChar,&a1obj))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QChar(a1obj,&a1,1,&iserr);

			if (iserr)
				return NULL;

			res = &ptr -> QString::insert( a0,* a1);

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	{
		unsigned a0;
		char a1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"ic",&a0,&a1))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = &ptr -> QString::insert( a0, a1);

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_insert);

	return NULL;
}

static PyObject *sipDo_QString_append(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		char a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"c",&a0))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = &ptr -> QString::append( a0);

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	{
		const QString * a0;
		PyObject *a0obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I",sipCanConvertTo_QString,&a0obj))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			int istemp0 = sipConvertTo_QString(a0obj,(QString **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = &ptr -> QString::append(* a0);

			if (istemp0)
				delete a0;

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_append);

	return NULL;
}

static PyObject *sipDo_QString_prepend(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		char a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"c",&a0))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = &ptr -> QString::prepend( a0);

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	{
		const QString * a0;
		PyObject *a0obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I",sipCanConvertTo_QString,&a0obj))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			int istemp0 = sipConvertTo_QString(a0obj,(QString **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = &ptr -> QString::prepend(* a0);

			if (istemp0)
				delete a0;

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_prepend);

	return NULL;
}

static PyObject *sipDo_QString_remove(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		unsigned a0;
		unsigned a1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"ii",&a0,&a1))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = &ptr -> QString::remove( a0, a1);

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_remove);

	return NULL;
}

static PyObject *sipDo_QString_replace(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		unsigned a0;
		unsigned a1;
		const QString * a2;
		PyObject *a2obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"iiI",&a0,&a1,sipCanConvertTo_QString,&a2obj))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			int istemp2 = sipConvertTo_QString(a2obj,(QString **)&a2,1,&iserr);

			if (iserr)
				return NULL;

			res = &ptr -> QString::replace( a0, a1,* a2);

			if (istemp2)
				delete a2;

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	{
		unsigned a0;
		unsigned a1;
		const QChar * a2;
		PyObject *a2obj;
		unsigned a3;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"iiIi",&a0,&a1,sipCanConvertTo_QChar,&a2obj,&a3))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QChar(a2obj,(QChar **)&a2,0,&iserr);

			if (iserr)
				return NULL;

			res = &ptr -> QString::replace( a0, a1, a2, a3);

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	{
		const QRegExp * a0;
		PyObject *a0obj;
		const QString * a1;
		PyObject *a1obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"II",sipCanConvertTo_QRegExp,&a0obj,sipCanConvertTo_QString,&a1obj))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QRegExp(a0obj,(QRegExp **)&a0,1,&iserr);
			int istemp1 = sipConvertTo_QString(a1obj,(QString **)&a1,1,&iserr);

			if (iserr)
				return NULL;

			res = &ptr -> QString::replace(* a0,* a1);

			if (istemp1)
				delete a1;

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_replace);

	return NULL;
}

static PyObject *sipDo_QString_setNum(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		int a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"C",&a0))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = &ptr -> QString::setNum( a0);

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	{
		double a0;
		char a1 = 'g';
		int a2 = 6;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"d|ci",&a0,&a1,&a2))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = &ptr -> QString::setNum( a0, a1, a2);

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_setNum);

	return NULL;
}

static PyObject *sipDo_QString_number(PyObject *,PyObject *sipArgs)
{
	int sipArgsParsed = 0;

	{
		int a0;
		int a1 = 10;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-C|i",&a0,&a1))
		{
			QString *res;

			res = new QString(QString::number( a0, a1));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	{
		double a0;
		char a1 = 'g';
		int a2 = 6;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-d|ci",&a0,&a1,&a2))
		{
			QString *res;

			res = new QString(QString::number( a0, a1, a2));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_number);

	return NULL;
}

static PyObject *sipDo_QString_setExpand(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		unsigned a0;
		QChar * a1;
		PyObject *a1obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"iI",&a0,sipCanConvertTo_QChar,&a1obj))
		{
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QChar(a1obj,&a1,1,&iserr);

			if (iserr)
				return NULL;

			ptr -> QString::setExpand( a0,* a1);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_setExpand);

	return NULL;
}

static PyObject *sipDo_QString_at(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		unsigned a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			QChar *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QChar(ptr -> QString::at( a0));

			return sipNewCppToSelf(res,sipClass_QChar,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_at);

	return NULL;
}

static PyObject *sipDo_QString_unicode(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			const QChar *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::unicode();

			return sipMapCppToSelf(res,sipClass_QChar);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_unicode);

	return NULL;
}

static PyObject *sipDo_QString_ascii(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			const char *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::ascii();

			if (res == NULL)
			{
				Py_INCREF(Py_None);
				return Py_None;
			}

			return PyString_FromString(res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_ascii);

	return NULL;
}

static PyObject *sipDo_QString_latin1(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			const char *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::latin1();

			if (res == NULL)
			{
				Py_INCREF(Py_None);
				return Py_None;
			}

			return PyString_FromString(res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_latin1);

	return NULL;
}

static PyObject *sipDo_QString_fromLatin1(PyObject *,PyObject *sipArgs)
{
	int sipArgsParsed = 0;

	{
		const char * a0;
		int a1 = -1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-s|i",&a0,&a1))
		{
			QString *res;

			res = new QString(QString::fromLatin1( a0, a1));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_fromLatin1);

	return NULL;
}

static PyObject *sipDo_QString_utf8(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QCString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QCString(ptr -> QString::utf8());

			return sipNewCppToSelf(res,sipClass_QCString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_utf8);

	return NULL;
}

static PyObject *sipDo_QString_fromUtf8(PyObject *,PyObject *sipArgs)
{
	int sipArgsParsed = 0;

	{
		const char * a0;
		int a1 = -1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-s|i",&a0,&a1))
		{
			QString *res;

			res = new QString(QString::fromUtf8( a0, a1));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_fromUtf8);

	return NULL;
}

static PyObject *sipDo_QString_local8Bit(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QCString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QCString(ptr -> QString::local8Bit());

			return sipNewCppToSelf(res,sipClass_QCString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_local8Bit);

	return NULL;
}

static PyObject *sipDo_QString_fromLocal8Bit(PyObject *,PyObject *sipArgs)
{
	int sipArgsParsed = 0;

	{
		const char * a0;
		int a1 = -1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-s|i",&a0,&a1))
		{
			QString *res;

			res = new QString(QString::fromLocal8Bit( a0, a1));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_fromLocal8Bit);

	return NULL;
}

static PyObject *sipDo_QString_setUnicode(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		const QChar * a0;
		PyObject *a0obj;
		unsigned a1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"Ii",sipCanConvertTo_QChar,&a0obj,&a1))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			int iserr = 0;

			sipConvertTo_QChar(a0obj,(QChar **)&a0,0,&iserr);

			if (iserr)
				return NULL;

			res = &ptr -> QString::setUnicode( a0, a1);

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_setUnicode);

	return NULL;
}

static PyObject *sipDo_QString_setLatin1(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		const char * a0;
		int a1 = -1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"s|i",&a0,&a1))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = &ptr -> QString::setLatin1( a0, a1);

			return sipMapCppToSelf(res,sipClass_QString);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_setLatin1);

	return NULL;
}

static PyObject *sipDo_QString_compare(PyObject *,PyObject *sipArgs)
{
	int sipArgsParsed = 0;

	{
		const QString * a0;
		PyObject *a0obj;
		const QString * a1;
		PyObject *a1obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-II",sipCanConvertTo_QString,&a0obj,sipCanConvertTo_QString,&a1obj))
		{
			int res;

			int iserr = 0;

			int istemp0 = sipConvertTo_QString(a0obj,(QString **)&a0,1,&iserr);
			int istemp1 = sipConvertTo_QString(a1obj,(QString **)&a1,1,&iserr);

			if (iserr)
				return NULL;

			res = QString::compare(* a0,* a1);

			if (istemp0)
				delete a0;

			if (istemp1)
				delete a1;

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_compare);

	return NULL;
}

static PyObject *sipDo_QString_compose(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			ptr -> QString::compose();

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_compose);

	return NULL;
}

static PyObject *sipDo_QString_basicDirection(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QChar::Direction res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = ptr -> QString::basicDirection();

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_basicDirection);

	return NULL;
}

static PyObject *sipDo_QString_visual(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QString)) == NULL)
		return NULL;

	{
		int a0 = 0;
		int a1 = -1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"|ii",&a0,&a1))
		{
			QString *res;
			QString *ptr;

			if ((ptr = (QString *)sipGetCppPtr(sipThis,sipClass_QString)) == NULL)
				return NULL;

			res = new QString(ptr -> QString::visual( a0, a1));

			return sipNewCppToSelf(res,sipClass_QString,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QString,sipName_qt_visual);

	return NULL;
}

// Cast a pointer to a type somewhere in its superclass hierachy.

const void *sipCast_QString(const void *ptr,PyObject *targetClass)
{
	if (targetClass == sipClass_QString)
		return ptr;

	return NULL;
}

static void sipDealloc_QString(sipThisType *sipThis)
{
	if (sipThis -> u.cppPtr != NULL)
	{
		if (sipIsPyOwned(sipThis))
			delete (QString *)sipThis -> u.cppPtr;
	}

	sipDeleteThis(sipThis);
}
static PyObject * sip__str__QString(PyObject *a0)
{
#line 407 "qstring.sip"
		QString *ptr;
 
		if ((ptr = (QString *)sipGetCppPtr((sipThisType *)a0,sipClass_QString)) == NULL)
			return NULL;
 
#if PY_VERSION_HEX >= 0x01060000
		PyObject *uobj, *sobj;

		if ((uobj = PyQtQStringToPyUni(ptr)) == NULL)
			return NULL;

		sobj = PyObject_Str(uobj);
		Py_DECREF(uobj);

		return sobj;
#else
		const char *s = *ptr;

		if (s == NULL)
			s = "";

		return PyString_FromString(s);
#endif
#line 2119 "sipqtQString.cpp"
}

PyObject *sipNew_QString(PyObject *sipSelf,PyObject *sipArgs)
{
	static sipExtraType et = {
		sipCast_QString,
		(void *)sipNewProxy_qt,
		NULL
	};

	sipThisType *sipThis = NULL;
	const void *sipNew = NULL;
	int sipFlags = SIP_PY_OWNED;
	int sipArgsParsed = 0;

	// See if there is something pending.

	sipNew = sipGetPending(&sipFlags);

	if (sipNew == NULL)
	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,"-"))
		{
			sipNew = new QString();
		}
	}

	if (sipNew == NULL)
	{
		QChar * a0;
		PyObject *a0obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-I",sipCanConvertTo_QChar,&a0obj))
		{
			int iserr = 0;

			sipConvertTo_QChar(a0obj,&a0,1,&iserr);

			if (iserr)
				return NULL;

			sipNew = new QString(* a0);
		}
	}

	if (sipNew == NULL)
	{
		const QString * a0;
		PyObject *a0obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-I",sipCanConvertTo_QString,&a0obj))
		{
			int iserr = 0;

			int istemp0 = sipConvertTo_QString(a0obj,(QString **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			sipNew = new QString(* a0);

			if (istemp0)
				delete a0;
		}
	}

	if (sipNew == NULL)
	{
		const QByteArray * a0;
		PyObject *a0obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-I",sipCanConvertTo_QByteArray,&a0obj))
		{
			int iserr = 0;

			int istemp0 = sipConvertTo_QByteArray(a0obj,(QByteArray **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			sipNew = new QString(* a0);

			if (istemp0)
				delete a0;
		}
	}

	if (sipNew == NULL)
	{
		const QChar * a0;
		PyObject *a0obj;
		unsigned a1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-Ii",sipCanConvertTo_QChar,&a0obj,&a1))
		{
			int iserr = 0;

			sipConvertTo_QChar(a0obj,(QChar **)&a0,0,&iserr);

			if (iserr)
				return NULL;

			sipNew = new QString( a0, a1);
		}
	}

	if (sipNew == NULL)
	{
		const char * a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"-s",&a0))
		{
			sipNew = new QString( a0);
		}
	}

	if (sipNew == NULL)
	{
		sipNoCtor(sipArgsParsed,sipName_qt_QString);
		return NULL;
	}

	// Wrap the object.

	if ((sipThis = sipCreateThis(sipSelf,sipNew,&sipType_QString,sipFlags,&et)) == NULL)
	{
		if (sipFlags & SIP_PY_OWNED)
			delete (QString *)sipNew;

		return NULL;
	}

	Py_INCREF(Py_None);
	return Py_None;
}

PyMethodDef sipClassAttrTab_QString[] = {
	{sipName_qt_isNull, sipDo_QString_isNull, METH_VARARGS, NULL},
	{sipName_qt_isEmpty, sipDo_QString_isEmpty, METH_VARARGS, NULL},
	{sipName_qt_length, sipDo_QString_length, METH_VARARGS, NULL},
	{sipName_qt_truncate, sipDo_QString_truncate, METH_VARARGS, NULL},
	{sipName_qt_fill, sipDo_QString_fill, METH_VARARGS, NULL},
	{sipName_qt_copy, sipDo_QString_copy, METH_VARARGS, NULL},
	{sipName_qt_arg, sipDo_QString_arg, METH_VARARGS, NULL},
	{sipName_qt_find, sipDo_QString_find, METH_VARARGS, NULL},
	{sipName_qt_findRev, sipDo_QString_findRev, METH_VARARGS, NULL},
	{sipName_qt_contains, sipDo_QString_contains, METH_VARARGS, NULL},
	{sipName_qt_left, sipDo_QString_left, METH_VARARGS, NULL},
	{sipName_qt_right, sipDo_QString_right, METH_VARARGS, NULL},
	{sipName_qt_mid, sipDo_QString_mid, METH_VARARGS, NULL},
	{sipName_qt_leftJustify, sipDo_QString_leftJustify, METH_VARARGS, NULL},
	{sipName_qt_rightJustify, sipDo_QString_rightJustify, METH_VARARGS, NULL},
	{sipName_qt_lower, sipDo_QString_lower, METH_VARARGS, NULL},
	{sipName_qt_upper, sipDo_QString_upper, METH_VARARGS, NULL},
	{sipName_qt_stripWhiteSpace, sipDo_QString_stripWhiteSpace, METH_VARARGS, NULL},
	{sipName_qt_simplifyWhiteSpace, sipDo_QString_simplifyWhiteSpace, METH_VARARGS, NULL},
	{sipName_qt_insert, sipDo_QString_insert, METH_VARARGS, NULL},
	{sipName_qt_append, sipDo_QString_append, METH_VARARGS, NULL},
	{sipName_qt_prepend, sipDo_QString_prepend, METH_VARARGS, NULL},
	{sipName_qt_remove, sipDo_QString_remove, METH_VARARGS, NULL},
	{sipName_qt_replace, sipDo_QString_replace, METH_VARARGS, NULL},
	{sipName_qt_setNum, sipDo_QString_setNum, METH_VARARGS, NULL},
	{sipName_qt_number, sipDo_QString_number, METH_VARARGS, NULL},
	{sipName_qt_setExpand, sipDo_QString_setExpand, METH_VARARGS, NULL},
	{sipName_qt_at, sipDo_QString_at, METH_VARARGS, NULL},
	{sipName_qt_unicode, sipDo_QString_unicode, METH_VARARGS, NULL},
	{sipName_qt_ascii, sipDo_QString_ascii, METH_VARARGS, NULL},
	{sipName_qt_latin1, sipDo_QString_latin1, METH_VARARGS, NULL},
	{sipName_qt_fromLatin1, sipDo_QString_fromLatin1, METH_VARARGS, NULL},
	{sipName_qt_utf8, sipDo_QString_utf8, METH_VARARGS, NULL},
	{sipName_qt_fromUtf8, sipDo_QString_fromUtf8, METH_VARARGS, NULL},
	{sipName_qt_local8Bit, sipDo_QString_local8Bit, METH_VARARGS, NULL},
	{sipName_qt_fromLocal8Bit, sipDo_QString_fromLocal8Bit, METH_VARARGS, NULL},
	{sipName_qt_setUnicode, sipDo_QString_setUnicode, METH_VARARGS, NULL},
	{sipName_qt_setLatin1, sipDo_QString_setLatin1, METH_VARARGS, NULL},
	{sipName_qt_compare, sipDo_QString_compare, METH_VARARGS, NULL},
	{sipName_qt_compose, sipDo_QString_compose, METH_VARARGS, NULL},
	{sipName_qt_basicDirection, sipDo_QString_basicDirection, METH_VARARGS, NULL},
	{sipName_qt_visual, sipDo_QString_visual, METH_VARARGS, NULL},
	{NULL}
};

int sipCanConvertTo_QString(PyObject *sipPy)
{
#line 433 "qstring.sip"
	// Allow a Python string (or a unicode string) whenever a QString is
	// expected.

	return (PyString_Check(sipPy) ||
#if PY_VERSION_HEX >= 0x01060000
		PyUnicode_Check(sipPy) ||
#endif
		sipIsSubClassInstance(sipPy,sipClass_QString));
#line 2313 "sipqtQString.cpp"
}

int sipConvertTo_QString(PyObject *sipPy,QString **sipCppPtr,int sipWillDeref,int *sipIsErr)
{
	if (*sipIsErr || sipPy == NULL)
		return 0;

#line 444 "qstring.sip"
	if (sipPy == Py_None)
	{
		*sipCppPtr = new QString();

		return 1;
	}

#if PY_VERSION_HEX >= 0x01060000
	if (PyUnicode_Check(sipPy))
	{
		QString *qs = new QString();

		qs -> setUnicodeCodes((ushort *)PyUnicode_AS_UNICODE(sipPy),PyUnicode_GET_SIZE(sipPy));

		*sipCppPtr = qs;

		return 1;
	}
#endif

	if (PyString_Check(sipPy))
	{
		*sipCppPtr = new QString(PyString_AS_STRING(sipPy));

		return 1;
	}

	*sipCppPtr = (QString *)sipConvertToCpp(sipPy,sipClass_QString,sipIsErr);

	return 0;
#line 2352 "sipqtQString.cpp"
}

QString *sipForceConvertTo_QString(PyObject *valobj,int *iserrp)
{
	if (*iserrp || valobj == NULL || valobj == Py_None)
		return NULL;

	if (sipCanConvertTo_QString(valobj))
	{
		QString *val;

		sipConvertTo_QString(valobj,&val,0,iserrp);

		return val;
	}

	sipBadClass(sipName_qt_QString);

	*iserrp = 1;

	return NULL;
}
