import CORBA,CompleteTest,CompleteTest__POA, Constants
import unittest,os,time

orb = CORBA.ORB_init([],CORBA.ORB_ID)
ior = open("ior").readline()
testharness = orb.string_to_object(ior)


class AccessorTest(unittest.TestCase):
    th = testharness

    def test_X1_trans_accessor_00_set(self):
        self.th.strvar = "Foo"
        self.th.intvar = 1
        self.th.floatvar = 99
        self.th.noobjvar = None
        self.th.objvar = self.th
        
    def test_X2_trans_accessor_01_get(self):
        assert(self.th.strvar == "Foo")
        assert(self.th.intvar == 1)
        assert(self.th.floatvar == 99)
        # breaks stress
        #assert(self.th.noobjvar == None)
        assert(self.th.objvar._is_equivalent(self.th))
        assert(self.th._is_equivalent(self.th.objvar))
        # Test O-P Extension
        assert(self.th.objvar == self.th)
        assert(self.th == self.th.objvar)

    # test calling method of th's self-reference objvar
    # doesn't really belong here
    def test_X3_trans_accessor_02_call(self):
        assert(self.th.objvar.get_long_seq() == (1,3,5,7))
        
    # These four functions check for variables not set in the IDL
    def do_bad_accessor_set(self):
        self.th.nothing = 666

    def test_X4_bad_accessor_set(self):
        self.assertRaises(CORBA.INTERNAL,self.do_bad_accessor_set)
        
    def do_bad_accessor_get(self):
        self.th.nothing = 666

    def test_X5_bad_accessor_get(self):
        self.assertRaises(CORBA.INTERNAL,self.do_bad_accessor_get)
        
    # FIXME/TODO: set_sequences, use as input to get
    # implement accessor test
    # implement transparent accessor test

suite = unittest.makeSuite(AccessorTest,'test')
