""" Helper to enable simple lazy module import. 

    'Lazy' means the actual import is deferred until an attribute is
    requested from the module's namespace. This has the advantage of
    allowing all imports to be done at the top of a script (in a
    prominent and visible place) without having a great impact
    on startup time.

    (c) 1998, Copyright Marc-Andre Lemburg; All Rights Reserved.
    See the documentation for further information on copyrights,
    or contact the author (mal@lemburg.com).
"""

class LazyModule:

    """ Lazy module class.

        Lazy modules are imported into the given namespaces whenever a
        non-special attribute (there are some attributes like __doc__
        that class instances handle without calling __getattr__) is
        requested. The module is then registered under the given name
        in locals usually replacing the import wrapper instance. The
        import itself is done using globals as global namespace.

	Example:
	ISO = LazyModule('ISO',locals(),globals())

	Later, requesting an attribute from ISO will load the module
	automatically:
	t = ISO.Week(1998,1,1)

    """
    def __init__(self,module,locals,globals):
	""" Create a LazyModule instance wrapping module name
	"""
	self.__locals__ = locals
	self.__globals__ = globals
	self.__submodule__ = module

    def __getattr__(self,what):
	""" Import the module now.
	"""
	name = self.__submodule__
	self.__locals__[name] = module = \
		  __import__(name,self.__locals__,self.__globals__,'*')
	#print 'lazy get',what,'from',name
	return getattr(module,what)

    def __repr__(self):
	return "<lazy module '%s'>" % self.__submodule__
