"""Generated client library for developerprojects version v1."""

from googlecloudapis.apitools.base.py import base_api
from googlecloudapis.developerprojects.v1 import developerprojects_v1_messages as messages


class DeveloperprojectsV1(base_api.BaseApiClient):
  """Generated client library for service developerprojects version v1."""

  MESSAGES_MODULE = messages

  _PACKAGE = u'developerprojects'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1'
  _CLIENT_ID = ''
  _CLIENT_SECRET = ''
  _USER_AGENT = ''
  _CLIENT_CLASS_NAME = u'DeveloperprojectsV1'
  _URL_VERSION = u'v1'

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None):
    """Create a new developerprojects handle."""
    url = url or u'https://www.googleapis.com/developerprojects/v1/'
    super(DeveloperprojectsV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers)
    self.projects = self.ProjectsService(self)

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(DeveloperprojectsV1.ProjectsService, self).__init__(client)
      self._method_configs = {
          'Create': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'developerprojects.projects.create',
              ordered_params=[],
              path_params=[],
              query_params=[u'appengineStorageLocation', u'createAppengineProject', u'enableIam'],
              relative_path=u'projects',
              request_field=u'project',
              request_type_name=u'DeveloperprojectsProjectsCreateRequest',
              response_type_name=u'Project',
              supports_download=False,
          ),
          'Get': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'developerprojects.projects.get',
              ordered_params=[u'projectId'],
              path_params=[u'projectId'],
              query_params=[u'options_fieldMask'],
              relative_path=u'projects/{projectId}',
              request_field='',
              request_type_name=u'DeveloperprojectsProjectsGetRequest',
              response_type_name=u'Project',
              supports_download=False,
          ),
          'List': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'developerprojects.projects.list',
              ordered_params=[],
              path_params=[],
              query_params=[u'maxResults', u'pageToken', u'query', u'retrievalOptions_fieldMask'],
              relative_path=u'projects',
              request_field='',
              request_type_name=u'DeveloperprojectsProjectsListRequest',
              response_type_name=u'ListProjectsResponse',
              supports_download=False,
          ),
          'Patch': base_api.ApiMethodInfo(
              http_method=u'PATCH',
              method_id=u'developerprojects.projects.patch',
              ordered_params=[u'projectId'],
              path_params=[u'projectId'],
              query_params=[],
              relative_path=u'projects/{projectId}/update',
              request_field='<request>',
              request_type_name=u'Project',
              response_type_name=u'Project',
              supports_download=False,
          ),
          'Update': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'developerprojects.projects.update',
              ordered_params=[u'projectId'],
              path_params=[u'projectId'],
              query_params=[],
              relative_path=u'projects/{projectId}/update',
              request_field='<request>',
              request_type_name=u'Project',
              response_type_name=u'Project',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Submits a request to create a project resource.

After the create request returns, any subsequent reads that query for the existence of the project, such that the project as created would pass the selection filter, must be able to find and return this project.

Initially, the project resource is owned by its creator exclusively. The creator must issue another call to adjust the access controls on the project resource in order to delegate the ownership to a different entity.

      Args:
        request: (DeveloperprojectsProjectsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Get(self, request, global_params=None):
      """Retrieves a limited project metadata set, given any project identifier.

In our federated data store, most project metadata actually live outside of this particular collection.

The request will fail in the following cases:

- The acting principal is not authorized to retrieve the information. - The project with the identifier requested is not known at the time the request has been executed. - The identifier requested does not identify a project resource.

Appropriate error codes for the failure cases are under discussion.

      Args:
        request: (DeveloperprojectsProjectsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    def List(self, request, global_params=None):
      """Lists all Google Cloud Platform Projects for the end user.

The response to this RPC may return only a page at a time.

      Args:
        request: (DeveloperprojectsProjectsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListProjectsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Patch(self, request, global_params=None):
      """Patch method for the projects service.

      Args:
        request: (Project) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Update(self, request, global_params=None):
      """Update method for the projects service.

      Args:
        request: (Project) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)
