#
# This module was written in 2007 by S James S Stapleton
# This module is released as PUBLIC DOMAIN
#
# Please respect the creator/author's intent and release all
# modifications as public domain. Thank you.
#



#
# This provides an inheritable lock, rlock, event and condition object set. I didn't put semaphores in here because they strike me
# dangerous, but feel free to add them in your own. Obviously it won't be that challanging. If you do make additions, please
# release them and keep them public domain in the spirit of the code here.
#



try: import threading as threading
except Exception, e:
    try: import dummy_threading as threading
    except Exception, f:
#        print "Failed to import threading: ", e
#        print "Failed to import dummy threading: ", f
#        print "exiting"
        raise Excepion(str(e) + "\n\n" + str(f))




class Ilock(object):
    """
So, I was writing a class that best inherited from a lock object. Python wouldn't let you do this. It said the thread.LockObject,
which you get from a threading.Lock() call and is actually a thread.lock is not inheritable.

Screw that.

This interfaces just as the result of a threading.Lock() would, but possibly with a bit of a performance penalty.
    """

    __lock   = None

    def __init__(self):
        self.__lock = threading.Lock()
#        print "My lock is:"
#        print type(self.__lock)
    #def __init__(self):

    def acquire(self, blocking=1):
        return self.__lock.acquire(blocking)
    #def sacquire(self, timeout=True):

    def release(self):
        return self.__lock.release()
    #def release(self):

#class Ilock(object):



class Irlock(object):
    """
So, I was writing a class that best inherited from a lock object. Python wouldn't let you do this. It said the thread.LockObject,
which you get from a threading.Lock() call and is actually a thread.lock is not inheritable.

Screw that.

This interfaces just as the result of a threading.Rlock() would, but possibly with a bit of a performance penalty.
    """

    __lock   = None

    def __init__(self):
        self.__lock = threading.RLock()
    #def __init__(self):

    def acquire(self, blocking=1):
        return self.__lock.acquire(blocking)
    #def sacquire(self, timeout=True):

    def release(self):
        return self.__lock.release()
    #def release(self):

#class Irlock(object):


class Icondition(object):
    """
So, I was writing a class that best inherited from a lock object. Python wouldn't let you do this. It said the thread.LockObject,
which you get from a threading.Lock() call and is actually a thread.lock is not inheritable.

Screw that.

This interfaces similar to the result of a threading.Condition() would, but possibly with a bit of a performance penalty. It does
have extra functionality with the notifyR and notifyAllR functions, which notify and release, instead of just notifying.

    """

    __cond   = None

    def __init__(self, lock=None):
        self.__cond = threading.Condition(lock)
    #def __init__(self, lock=None):

    def acquire(self, *args):
        return self.__cond.acquire(args)
    #def acquire(self, *args):

    def wait(self, timeout=None):
        return self.__cond.wait(timeout)
    #def wait(self, timeout=None):

    def release(self):
        self.__cond.release()
    #def release(self):

    def notify(self):
        return self.__cond.notify(self)
    #def notify(self):

    def notifyAll(self):
        return self.__cond.notifyAll(self)
    #def notifyAll(self):

    def notifyR(self):
        "Notify and release"
        self.__cond.notify(self)
        self.__cond.release()
    #def notify(self):

    def notifyAllR(self):
        "Notify all and release"
        self.__cond.notifyAll(self)
        self.__conf.release()
    #def notifyAll(self):

#class Icondition(object):



class Ievent(object):
    """
So, I was writing a class that best inherited from a lock object. Python wouldn't let you do this. It said the thread.LockObject,
which you get from a threading.Lock() call and is actually a thread.lock is not inheritable.

Screw that.

This interfaces similar to the result of a threading.Event() would, but possibly with a bit of a performance penalty.

    """

    __even   = None

    def __init__(self):
        self.__even = threading.Event()
    #def __init__(self, lock=None):

    def isSet():
        self.__even.isSet()
    #def isSet():

    def set():
        self.__even.set()
    #def set();

    def clear():
        self.__even.clear()
    #def clear():

    def wait(timeout=None):
        self.__even.wait(timeout)
    #def wait(timeout=None):

#class Ievent(Object):






