# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TopologySingleResource(Model):
    """TopologySingleResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_id: Azure resource id
    :vartype resource_id: str
    :ivar severity: The security severity of the resource
    :vartype severity: str
    :ivar recommendations_exist: Indicates if the resource has security
     recommendations
    :vartype recommendations_exist: bool
    :ivar network_zones: Indicates the resource connectivity level to the
     Internet (InternetFacing, Internal ,etc.)
    :vartype network_zones: str
    :ivar topology_score: Score of the resource based on its security severity
    :vartype topology_score: int
    :ivar location: The location of this resource
    :vartype location: str
    :ivar parents: Azure resources connected to this resource which are in
     higher level in the topology view
    :vartype parents:
     list[~azure.mgmt.security.models.TopologySingleResourceParent]
    :ivar children: Azure resources connected to this resource which are in
     lower level in the topology view
    :vartype children:
     list[~azure.mgmt.security.models.TopologySingleResourceChild]
    """

    _validation = {
        'resource_id': {'readonly': True},
        'severity': {'readonly': True},
        'recommendations_exist': {'readonly': True},
        'network_zones': {'readonly': True},
        'topology_score': {'readonly': True},
        'location': {'readonly': True},
        'parents': {'readonly': True},
        'children': {'readonly': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'recommendations_exist': {'key': 'recommendationsExist', 'type': 'bool'},
        'network_zones': {'key': 'networkZones', 'type': 'str'},
        'topology_score': {'key': 'topologyScore', 'type': 'int'},
        'location': {'key': 'location', 'type': 'str'},
        'parents': {'key': 'parents', 'type': '[TopologySingleResourceParent]'},
        'children': {'key': 'children', 'type': '[TopologySingleResourceChild]'},
    }

    def __init__(self, **kwargs) -> None:
        super(TopologySingleResource, self).__init__(**kwargs)
        self.resource_id = None
        self.severity = None
        self.recommendations_exist = None
        self.network_zones = None
        self.topology_score = None
        self.location = None
        self.parents = None
        self.children = None
