# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MongoDbError(Model):
    """Describes an error or warning that occurred during a MongoDB migration.

    :param code: The non-localized, machine-readable code that describes the
     error or warning
    :type code: str
    :param count: The number of times the error or warning has occurred
    :type count: int
    :param message: The localized, human-readable message that describes the
     error or warning
    :type message: str
    :param type: The type of error or warning. Possible values include:
     'Error', 'ValidationError', 'Warning'
    :type type: str or ~azure.mgmt.datamigration.models.MongoDbErrorType
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'message': {'key': 'message', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MongoDbError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.count = kwargs.get('count', None)
        self.message = kwargs.get('message', None)
        self.type = kwargs.get('type', None)
