# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class InputDirectory(Model):
    """Input directory for the job.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The id for the input directory. The path of the input
     directory will be available as a value of an environment variable with
     AZ_BATCHAI_INPUT_<id> name, where <id> is the value of id attribute.
    :type id: str
    :param path: Required. The path to the input directory.
    :type path: str
    """

    _validation = {
        'id': {'required': True},
        'path': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InputDirectory, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.path = kwargs.get('path', None)
