import os

from Ft.Server.Common import ResourceTypes,DocumentReference

import test_helper
    
def test_valid(tester):

    tester.startTest("Internal Sheet vs Internal Doc")
    repo = test_helper.GetRepo(tester)
    doc = repo.fetchResource("/test/doc1")
    sheet  = repo.fetchResource("/test/sheet1")
    res = doc.applyXslt([sheet],{})
    tester.compare('text/plain',res[1])
    tester.compare(result1,res[0])
    repo.txRollback()
    tester.testDone()

    tester.startTest("Internal Doc Ref Sheet vs Internal Doc")
    repo = test_helper.GetRepo(tester)
    doc = repo.fetchResource("/test/doc1")
    dr  = DocumentReference.InternalDocumentReference("/test/sheet2")
    res = doc.applyXslt([dr],{})
    tester.compare('text/html',res[1])
    tester.compare(result2,res[0])
    repo.txRollback()
    tester.testDone()

    tester.startTest("Sheet URI vs Internal Doc")
    repo = test_helper.GetRepo(tester)
    doc = repo.fetchResource("/test/doc1")
    res = doc.applyXslt(["/test/sheet2"],{})
    tester.compare('text/html',res[1])
    tester.compare(result2,res[0])
    repo.txRollback()
    tester.testDone()



def init(tester):

    tester.startTest("Init")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    repo.createContainer("/test",1)
    repo.createDocument('/test/doc1',DOC1,forcedType=ResourceTypes.ResourceType.XML_DOCUMENT)
    repo.createDocument('/test/sheet1',SHEET1,forcedType=ResourceTypes.ResourceType.XSLT_DOCUMENT)
    repo.createDocument('/test/sheet2',SHEET2,forcedType=ResourceTypes.ResourceType.XSLT_DOCUMENT)
    repo.txCommit()
    tester.testDone()

   
DOC1="""<docelem v='foo'/>"""


SHEET1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="text"/>
  <xsl:template match="/" priority="-1">
  Sheet 1
  </xsl:template>
</xsl:stylesheet>"""

SHEET2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:include href="sheet1"/>
  <xsl:output method='html'/>
  <xsl:template match="/">

  Sheet 2
  </xsl:template>
</xsl:stylesheet>"""


result1 = """
  Sheet 1
  """

result2 = '\n\n  Sheet 2\n  '

def Test(tester):
    init(tester)
    test_valid(tester)

