__revision__ = "$Id: __init__.py,v 1.2 2002/07/17 22:58:13 jkloth Exp $"

from Ft.Lib.TestSuite import RemoveTests, SortTests

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)
    
    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """

    ignored_files = ['test_util',
                     'nested_definitions',
                     'operation_defs',
                     ]
    RemoveTests(files, ignored_files)

    ordered_files = ['objects',
                     'binding',
                     'all_types',
                     'collections',
                     ]
    SortTests(files, ordered_files)

    return (dirs, files)
