########################################################################
#
# File Name: 	        Union.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Union.py.html
#
"""
Implements the Union meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.MetaData import ScopedType
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.MetaData import UnionCase
from Ft.Ods.MetaData import MetaKind
from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

class Union(ScopedType.ScopedType):
    def __init__(self,db,data):
        ScopedType.ScopedType.__init__(self,db,data,MetaKind.mk_union)

    #These three interfaces are for any scopedtype
    #We must support them
    def _4ods_getBoundChildren(self):
        return self.cases
    def _4ods_boundChild(self,obj):
        self.add_cases(obj)
    def _4ods_unboundChild(self,obj):
        self.remove_cases(obj)



    def form_switch_type(self,target,inverse = 1):
        from Ft.Ods.MetaData import Type
        self._4ods_formRelationship('switch_type',Type.Type,'unions','add',target,inverse)

    def drop_switch_type(self,target,inverse = 1):
        self._4ods_dropRelationship('switch_type','unions','remove',target,inverse)

    def add_cases(self,target,inverse = 1):
        self._4ods_addRelationship('cases',UnionCase.UnionCase,'union_type','form',target,inverse)
    form_cases=add_cases
    def remove_cases(self,target,inverse = 1):
        self._4ods_removeRelationship('cases','union_type','drop',target,inverse)
    drop_cases=remove_cases



    def _4ods_getOdl(self,indent):
        st = indent + 'union %s switch (%s) {\n' % (self.name,self.switch_type.absolute_name())
        for c in self.cases:
            st = st + c._4ods_getOdl(indent + '  ') + ';\n'
        st = st + indent + '}'

        return st

    def _4ods_getOdmgType(self):
        return Constants.Types.UNION

    def _4ods_checkRemove(self):
        return 1

    def _4ods_getGeneratedMetaClasses(self,found,checked):
        if self in checked: return
        checked.append(self)
        found.append(self)
        self.switch_type._4ods_getGeneratedMetaClasses(found,checked)
        for c in self.cases:
            c._4ods_getGeneratedMetaClasses(found,checked)
        return found



    _tupleNames =  (('cases',),('switch_type',))

    _tupleDefinitions = {'cases':{td.TYPE:Constants.Types.LIST_COLLECTION,
                                  td.READONLY:1,
                                  td.RELATIONSHIP:1,
                                  td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                  },
                         'switch_type':{td.TYPE:Constants.Types.ROBJECT,
                                        td.READONLY:1,
                                        td.RELATIONSHIP:1,
                                        },
                         }
        
    _localExtents = ()
