#Oliver Becker <obecker@informatik.hu-berlin.de> wonders about namespace axis conformance

from Xslt import test_harness

sheet_1 = """\
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="el">
   <xsl:copy>
      <xsl:copy-of select="@*" />
      <xsl:attribute name="prefix:att2" 
                     namespace="uri2">bar</xsl:attribute>
   </xsl:copy>
</xsl:template>

</xsl:stylesheet>"""


source_1 = """\
<el xmlns:prefix="uri1" prefix:att="foo" />"""

expected_1 = """\
<?xml version='1.0' encoding='UTF-8'?>
<el genprefix1:att2='bar' prefix:att='foo' xmlns:genprefix1='uri2' xmlns:prefix='uri1'/>"""

def Test(tester):
    tester.startGroup("Borrowed: ob_20010518")
    
    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    compareFunc = cmp,
                                    )

    xtest.test(tester)
    tester.groupDone()
					    
    return