#Martin Sevigny's Saxon bug report, 29 Mar 2000

from Xslt import test_harness

sheet_1 = """<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="xml" indent="yes"/>
  <xsl:template match="Record">
    <TestRecord>
      <xsl:apply-templates/>
    </TestRecord>
  </xsl:template>
  <xsl:template match="Field[@No='606']/Subfield[@No='x']">
    <GotAMatch><xsl:apply-templates/></GotAMatch>
  </xsl:template>
</xsl:stylesheet>"""


source_1="""<?xml version="1.0" ?>
<Record id='1'>
  <Field No="606">
    <Subfield No="x">Use</Subfield>
  </Field>
</Record>"""


expected_1="""<?xml version='1.0' encoding='UTF-8'?>
<TestRecord>
  
    <GotAMatch>Use</GotAMatch>
  
</TestRecord>"""


def Test(tester):

    tester.startGroup("Borrowed: ms_20000329")
    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    )

    xtest.test(tester)
    tester.groupDone()
    return