#Erik Dasque's <edasque@silverstream.com> RDFtoRSS converter problem, 28 April 2000

from Xslt import test_harness

source_1 = """<?xml version="1.0" standalone="yes"?>
<rdf:RDF xmlns="http://my.netscape.com/rdf/simple/0.9/"
     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
>
  <channel>
    <title>JavaWorld</title>
    <link>http://www.javaworld.com</link>
    <description>
      Add JavaWorld to your My Netscape page! The
      JavaWorld channel lets you stay on top of the latest
      developer tips, tutorials, news, and resources offered by
      JavaWorld.
    </description>
  </channel>
  <image>
    <title>JavaWorld Logo</title>
    <url>http://www.javaworld.com/icons/jw-mynetscape.gif</url>
    <link>http://www.javaworld.com</link>
  </image>
  <item>
    <title>&quot;Streaming JavaWorld&quot; -- the streaming audio news and talk for Java project managers</title>
    <link>http://www.javaworld.com/common/jw-streaming.html?myns</link>
  </item>
  <item>
    <title>Streaming JavaWord: An audio program for Java project managers and programmers</title>
    <link>http://www.javaworld.com/common/jw-streaming.html?myns</link>
  </item>
  <item>
    <title>Programming Java Devices: An Overview</title>
    <link>http://www.javaworld.com/jw-07-1999/jw-07-device.html?myns</link>
  </item>
  <textinput>
    <title>GO!</title>
    <description>Search JavaWorld</description>
    <name>col=jw&amp;qt</name>
    <link>http://search.javaworld.com/query.html</link>
  </textinput>
</rdf:RDF>"""

expected = """<?xml version='1.0' encoding='UTF-8'?>
<rss><channel xmlns='http://my.netscape.com/rdf/simple/0.9/'>
    <title>JavaWorld</title>
    <link>http://www.javaworld.com</link>
    <description>
      Add JavaWorld to your My Netscape page! The
      JavaWorld channel lets you stay on top of the latest
      developer tips, tutorials, news, and resources offered by
      JavaWorld.
    </description>
  <image>
    <title>JavaWorld Logo</title>
    <url>http://www.javaworld.com/icons/jw-mynetscape.gif</url>
    <link>http://www.javaworld.com</link>
  </image><item>
    <title>"Streaming JavaWorld" -- the streaming audio news and talk for Java project managers</title>
    <link>http://www.javaworld.com/common/jw-streaming.html?myns</link>
  </item><item>
    <title>Streaming JavaWord: An audio program for Java project managers and programmers</title>
    <link>http://www.javaworld.com/common/jw-streaming.html?myns</link>
  </item><item>
    <title>Programming Java Devices: An Overview</title>
    <link>http://www.javaworld.com/jw-07-1999/jw-07-device.html?myns</link>
  </item></channel></rss>"""


def Test(tester):

    tester.startGroup("Borrowed: ed_20000428.py")

    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(uri='Xslt/Borrowed/rdf2rss.xslt')
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected,
                                    )

    xtest.test(tester)
    tester.groupDone()
    return
    