def Test(tester):

    tester.startGroup('Numeric Expressions')
    
    tester.startTest('Creating test environment')
    from xml.xpath import ParsedExpr

    num3 = ParsedExpr.ParsedNLiteralExpr(3)
    num4N = ParsedExpr.ParsedNLiteralExpr(-4)
    num4p5 = ParsedExpr.ParsedNLiteralExpr(4.5)
    
    # Quotes are REQUIRED around literals
    str1 = ParsedExpr.ParsedLiteralExpr('"1"')
    str2 = ParsedExpr.ParsedLiteralExpr('"2"')
    str3 = ParsedExpr.ParsedLiteralExpr('"3"')
    str4 = ParsedExpr.ParsedLiteralExpr('"4"')
    str5 = ParsedExpr.ParsedLiteralExpr('"5"')
    str1N = ParsedExpr.ParsedLiteralExpr('"-1"')
    str2N = ParsedExpr.ParsedLiteralExpr('"-2"')
    str3N = ParsedExpr.ParsedLiteralExpr('"-3"')
    str4N = ParsedExpr.ParsedLiteralExpr('"-4"')
    str5N = ParsedExpr.ParsedLiteralExpr('"-5"')
    strPi = ParsedExpr.ParsedLiteralExpr('"3.1415926535"')
    strHi = ParsedExpr.ParsedLiteralExpr('"Hi"')
    
    #  *  -> 0
    # div -> 1
    # mod -> 2
    multiply_tests = [((2,str5,str2), 1),
                      ((2,str5,str2N), -1),
                      ((2,str5N,str2), 1),
                      ((2,str5N,str2N), -1),
                      ((1,str5N,str2), -2.5),
                      ((1,str4N,str2N), 2),
                      ((0,str5N,str2), -10),
                      ((0,str4N,str2N), 8),
                      ]
                      
    # + -> 1
    # - -> -1
    addition_tests = [((1, str5, str2), 7),
                      ((1, str3, str2N), 1),
                      ((-1, str5, str2), 3),
                      ((-1, str3, str2N), 5),
                      ]
    
    unary_tests = [((str5,), -5),
                   ((str2N,), 2),
                   ]
    
    tests = [(ParsedExpr.ParsedMultiplicativeExpr, multiply_tests),
             (ParsedExpr.ParsedAdditiveExpr, addition_tests),
             (ParsedExpr.ParsedUnaryExpr, unary_tests),
             ]
    tester.testDone()
             
    for klass,cases in tests:
        tester.startTest('Performing test of ' + klass.__name__)
        for args,expected in cases:
            expr = apply(klass, args)
            result = expr.evaluate(None)
            tester.compare(expected, result, 'Wrong result evaluating "%s".' % repr(expr))
        tester.testDone()

    return tester.groupDone()
