import xml.dom.ext

source_1 = """\
<RDF
  xmlns="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:n="http://www.nist.gov/units/">
  <Description about="John_Smith">
    <n:weight rdf:parseType="Resource">
      <rdf:value>200</rdf:value>
      <n:units rdf:resource="http://www.nist.gov/units/Pounds"/>
      <rdf:value>91</rdf:value>
      <n:units rdf:resource="http://www.nist.gov/units/Kilograms"/>
    </n:weight>
  </Description>
</RDF>
"""

source_2 = """\
<RDF
  xmlns="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:n="http://www.nist.gov/units/">
  <Description about="John_Smith">
    <n:weight rdf:parseType="Resource">
      <rdf:value>200</rdf:value>
      <n:units rdf:resource="http://www.nist.gov/units/Pounds"/>
      <rdf:value>91</rdf:value>
      <n:units rdf:resource="http://www.nist.gov/units/Kilograms"/>
    </n:weight>
  </Description>
</RDF>
"""

source_3 = """\
<RDF
  xmlns="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:n="http://www.nist.gov/units/">
  <Description about="John_Smith">
    <n:weight rdf:parseType="Resource">
      <rdf:value>200</rdf:value>
      <n:units rdf:resource="http://www.nist.gov/units/Pounds"/>
    </n:weight>
    <n:weight rdf:parseType="Resource">
      <rdf:value>91</rdf:value>
      <n:units rdf:resource="http://www.nist.gov/units/Kilograms"/>
    </n:weight>
  </Description>
</RDF>
"""

source_4 = """\
<RDF
  xmlns="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:n="http://www.nist.gov/units/">
  <Description about="John_Smith">
    <n:weight rdf:parseType="Resource">
      <n:Pounds>200</n:Pounds>
      <n:Kilograms>91</n:Kilograms>
    </n:weight>
  </Description>
</RDF>
"""

source_5 = """\
<RDF
  xmlns="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:n="http://www.nist.gov/units/">
  <Description about="John_Smith">
    <n:weight rdf:parseType="Resource">
      <n:Pounds>200</n:Pounds>
      <n:Kilograms>91</n:Kilograms>
      <n:Stone rdf:parseType="Resource">
          <n:Stone>14</n:Stone>
          <n:Pounds>4</n:Pounds>
      </n:Stone>
    </n:weight>
  </Description>
</RDF>
"""


def Test():
    from Ft.Rdf.Drivers import Memory
    db = Memory.CreateDb('mydemo')

    from Ft.Rdf import Model
    m = Model.Model('http://article20001111.uche.ogbuji.net', db)

    from xml.dom.ext.reader import PyExpat
    reader = PyExpat.Reader()
    doc = reader.fromString(source_1)

    from Ft.Rdf.Serializers.Dom import Serializer
    serializer = Serializer()
    
    serializer.deserialize(m, doc, 'http://article20001111.uche.ogbuji.net')

    print m.complete(None, None, None)

    outdoc = serializer.serialize(m)
    xml.dom.ext.PrettyPrint(outdoc)
    reader.releaseNode(doc)
    reader.releaseNode(outdoc)
    return


if __name__ == '__main__':
    Test()


From: "Jeremy Carroll" <jjc@hplb.hpl.hp.com>
To: <www-rdf-interest@w3.org>
Date: Tue, 13 Mar 2001 15:44:01 -0000 (08:44 MST)
Subject: Weights and Measures

Lee Jonas wrote:
> -----Original Message-----
> Sent: 12 March 2001 16:38
> To: www-rdf-interest@w3.org
> Subject: Re: Again: Anonymous Resources
[..omit..]
> However, consider the example the RDF M&S spec gives for qualified values.
> It describes measurements as the coupling of the unit of measurement with
> the quantity via an intermediary resource, e.g. 8-Kg, 128-Mb,
> 2-meters, etc.

I am new to RDF, (I've just started working with Brian McBride); I had to go
and look at the spec to understand this, and I was surprised.

>From the spec http://www.w3.org/TR/REC-rdf-syntax/ :

----------------
A common use of this higher-arity capability is when dealing with units of
measure. A person's weight is not just a number such as "200", it also
includes the unit of measure used. In this case we might be using either
pounds or kilograms. We could use a relationship with an additional arc to
record the fact that John Smith is a rather strapping gentleman:

<RDF
  xmlns="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:n="http://www.nist.gov/units/">
  <Description about="John_Smith">
    <n:weight rdf:parseType="Resource">
      <rdf:value>200</rdf:value>
      <n:units rdf:resource="http://www.nist.gov/units/Pounds"/>
    </n:weight>
  </Description>
</RDF>
-------------------

This is counterintuitive in that it (incorrectly) gives only one (numeric)
value for John Smith's weight.
It is natural, at least to me, to want to augment the above graph with
John's weight in Kilo's. This is a further attribute of John's weight,
rather than an additional description of John.

Unfortunately, the following is unintelligible:

<RDF
  xmlns="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:n="http://www.nist.gov/units/">
  <Description about="John_Smith">
    <n:weight rdf:parseType="Resource">
      <rdf:value>200</rdf:value>
      <n:units rdf:resource="http://www.nist.gov/units/Pounds"/>
      <rdf:value>91</rdf:value>
      <n:units rdf:resource="http://www.nist.gov/units/Kilograms"/>
    </n:weight>
  </Description>
</RDF>

And, this one, seems to suggest John has two different weights:
<RDF
  xmlns="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:n="http://www.nist.gov/units/">
  <Description about="John_Smith">
    <n:weight rdf:parseType="Resource">
      <rdf:value>200</rdf:value>
      <n:units rdf:resource="http://www.nist.gov/units/Pounds"/>
    </n:weight>
    <n:weight rdf:parseType="Resource">
      <rdf:value>91</rdf:value>
      <n:units rdf:resource="http://www.nist.gov/units/Kilograms"/>
    </n:weight>
  </Description>
</RDF>

I would prefer to see the weight with two properties, one the weight in
Kilo's another the weight in pounds. Both of these properties could be
subproperties of rdf:value.
This might suggest:
<RDF
  xmlns="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:n="http://www.nist.gov/units/">
  <Description about="John_Smith">
    <n:weight rdf:parseType="Resource">
      <n:Pounds>200</n:Pounds>
      <n:Kilograms>91</n:Kilograms>
    </n:weight>
  </Description>
</RDF>


Such an approach allows for additive extensions of models to support
additional measurement systems, rather than requiring the transformation of
a model from say a metric to an imperial system. Moreover, if the weight
node were not anonymous, then this addition could come from a separate
document generated automatically by say a units' conversion program.

A particularly nasty variant is the English habit of quoting body weights in
Stone and Pounds, so if John lives in London, England, he weighs 14 Stone
and 4 pounds, extending the graph further gives:

<RDF
  xmlns="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:n="http://www.nist.gov/units/">
  <Description about="John_Smith">
    <n:weight rdf:parseType="Resource">
      <n:Pounds>200</n:Pounds>
      <n:Kilograms>91</n:Kilograms>
      <n:Stone rdf:parseType="Resource">
          <n:Stone>14</n:Stone>
          <n:Pounds>4</n:Pounds>
      </n:Stone>
    </n:weight>
  </Description>
</RDF>

where the semantics of the pair of arcs <n:Pounds>200</n:Pounds> and
<n:Stone rdf:parseType="Resource"/> is that of alternative description,
whereas the pair of arcs <n:Stone>14</n:Stone> & <n:Pounds>4</n:Pounds>


Jeremy Carroll
HP Labs, Bristol
