from Ft.Rdf.Drivers import Memory
from Ft.Rdf import Model, Statement
def CreateInfEng():
    from Ft.Rdf.Inference import InferenceEngine
    db = Memory.DbAdapter('kb')
    db.begin()
    kb = Model.Model(db)
    return InferenceEngine.InferenceEngine(kb)

def Test(test):
    test.startGroup('InferenceEngine')
    
    test.startTest('Syntax')
    if 1:
    #try:
        from Ft.Rdf.Inference import InferenceEngine
        from Ft.Rdf.Inference import Common
        from Ft.Rdf.Inference import Query
        from Ft.Rdf.Inference import Action
    #except:
    #    test.error('Error in syntax', 1)
    test.testDone()

    test.startTest('Single Query with SV')
    sv = Common.SkolemVariableArgument("X")
    q1 = Query.SingleQuery("http://spam.com#wet",(sv,))

    infeng = CreateInfEng()

    #Assert directly to RDF
    wet = Statement.Statement('http://ogbuji.net#uche', 'http://spam.com#wet', '1')
    infeng.workspace.add(wet)

    result = q1.query(infeng, None)
    test.testResults([('http://ogbuji.net#uche','http://spam.com#wet','1')],result)

    test.startTest('Single Query with String')
    sl = Common.StringLiteralArgument("arg1","http://ogbuji.net#uche")
    q1 = Query.SingleQuery("http://spam.com#wet",(sl,))

    infeng = CreateInfEng()

    #Assert directly to RDF
    infeng.workspace.add(wet)

    result = q1.query(infeng, None)
    test.testResults([('http://ogbuji.net#uche','http://spam.com#wet','1')],result)


    test.startTest('Single Query with String List')
    sl = Common.StringListLiteralArgument("arg1",["http://ogbuji.net#uche","http://olsons.net#mike"])
    q1 = Query.SingleQuery("http://spam.com#wet",(sl,))

    infeng = CreateInfEng()

    #Assert directly to RDF
    infeng.workspace.add(wet)

    result = q1.query(infeng, None)
    test.testResults([('http://ogbuji.net#uche','http://spam.com#wet','1')],result)

    test.startTest('Single Query with String')
    sl = Common.StringLiteralArgument("arg1","http://ogbuji.net#uche")
    q1 = Query.SingleQuery("http://spam.com#wet",(sl,))

    infeng = CreateInfEng()

    #Assert directly to RDF
    infeng.workspace.add(wet)

    result = q1.query(infeng, None)
    test.testResults([('http://ogbuji.net#uche','http://spam.com#wet','1')],result)
    
    test.startTest('Single Query nested')
    sl = Common.StringLiteralArgument("arg1","http://ogbuji.net#uche")
    q1 = Query.SingleQuery("http://spam.com#wet",(sl,))
    c1 = Action.StatementSubject(q1)
    q2 = Query.SingleQuery("http://spam.com#running",(c1,))

    infeng = CreateInfEng()

    #Assert directly to RDF
    running = Statement.Statement('http://ogbuji.net#uche', 'http://spam.com#running', '1')
    infeng.workspace.add(wet)
    infeng.workspace.add(running)

    result = q2.query(infeng, None)
    test.testResults([('http://ogbuji.net#uche','http://spam.com#running','1')],result)



    #Test Dual Queries
    test.startTest('Dual Query SV,SV')
    sv = Common.SkolemVariableArgument("X")
    q1 = Query.DualQuery("http://spam.com#creator",(sv,sv))

    infeng = CreateInfEng()

    #Assert directly to RDF
    book1 = Statement.Statement('http://ogbuji.net#uche', 'http://spam.com#creator', 'A Book')
    book2 = Statement.Statement('http://ogbuji.net#uche', 'http://spam.com#creator', 'http://ogbuji.net#uche')
    infeng.workspace.add([book1,book2])

    result = q1.query(infeng, None)
    
    test.testResults([('http://ogbuji.net#uche','http://spam.com#creator','http://ogbuji.net#uche')],result)
    

    test.startTest('Dual Query SV1,SV2')
    sv = Common.SkolemVariableArgument("X")
    sv1 = Common.SkolemVariableArgument("Y")
    q1 = Query.DualQuery("http://spam.com#creator",(sv,sv1))

    infeng = CreateInfEng()

    #Assert directly to RDF
    infeng.workspace.add([book1,book2])

    result = q1.query(infeng, None)
    
    test.testResults([('http://ogbuji.net#uche', 'http://spam.com#creator','A Book'),('http://ogbuji.net#uche', 'http://spam.com#creator','http://ogbuji.net#uche')],result)
    

    test.startTest('Dual Query SV1,""')
    sv = Common.SkolemVariableArgument("X")
    sl = Common.StringLiteralArgument("arg1","A Book")
    q1 = Query.DualQuery("http://spam.com#creator",(sv,sl))

    infeng = CreateInfEng()

    #Assert directly to RDF
    infeng.workspace.add([book1,book2])

    result = q1.query(infeng, None)
    
    test.testResults([('http://ogbuji.net#uche', 'http://spam.com#creator','A Book')],result)
    
    test.startTest('Dual Query "",SV1')
    sv = Common.SkolemVariableArgument("X")
    sl = Common.StringLiteralArgument("arg1","http://ogbuji.net#uche")
    q1 = Query.DualQuery("http://spam.com#creator",(sl,sv))

    infeng = CreateInfEng()

    #Assert directly to RDF
    infeng.workspace.add([book1,book2])

    result = q1.query(infeng, None)
    
    test.testResults([('http://ogbuji.net#uche', 'http://spam.com#creator','A Book'),('http://ogbuji.net#uche', 'http://spam.com#creator','http://ogbuji.net#uche')],result)
    
    test.startTest('Dual Query "",""')
    sl = Common.StringLiteralArgument("arg1","A Book")
    sl1 = Common.StringLiteralArgument("arg1","http://ogbuji.net#uche")
    q1 = Query.DualQuery("http://spam.com#creator",(sl1,sl))

    infeng = CreateInfEng()

    #Assert directly to RDF
    infeng.workspace.add([book1,book2])

    result = q1.query(infeng, None)
    
    test.testResults([('http://ogbuji.net#uche', 'http://spam.com#creator','A Book')],result)
    
    test.testDone()
    test.groupDone()






if __name__ == '__main__':
    import sys
    from Ft.Lib import TestSuite

    testmgr = TestSuite.TestSuite()
    ret_val = Test(testmgr)
    sys.exit(ret_val)

