
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

def Test(tester):

    from Ft.Ods import Database
    from Ft.Ods.MetaData import Module, MetaKind
    from Ft.Ods.StorageManager import Adapters
    from Ft.Ods.StorageManager.Adapters import Constants

    tester.startGroup("Module Driver %s" % tester.test_data['driver'])

    #Can't have a full DB here
    tester.startTest("Init DB")
    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinit(DBNAME,adapter)
    else:
        manager.create(DBNAME)
        manager.init(DBNAME)

    tester.testDone()
    

    #Create a new module, set some info and commit
    tester.startTest("Create Module")
    db = Database.Database()
    db.open(DBNAME)
    try:

        tx = db.new()
        tx.begin()

        for e in MetaKind.MetaKind.elements:
            adapter.newPythonLiteralClass(tx._db,Constants.Types.ENUMERATION,e._typeId,e.__class__)


        m = Module.Module(db,None,None)
        m.name = 'New Module'
        m.comment = 'Comment'


        tester.testResults("New Module",m.name,done = 0,msg="Name")
        tester.testResults("Comment",m.comment,done = 0,msg="Comment")
        tester.testResults("mk_module",m.meta_kind._n,done = 0,msg="meta_kind")
        tester.testResults(None,m.definedIn,done = 0,msg="definedIn")

        tx.commit()

        rid = m._4ods_getId()
        tester.testDone()
        tester.startTest("Read Module")
        tx = db.new()
        tx.begin()

        m = db._4ods_getPersistentObjectById(Constants.Types.ROBJECT,rid)

        tester.testResults("New Module",m.name,done = 0,msg="Name")
        tester.testResults("Comment",m.comment,done = 0,msg="Comment")
        tester.testResults("mk_module",m.meta_kind._n,done = 0,msg="meta_kind")
        tester.testResults(None,m.definedIn,done = 0,msg="definedIn")

        tx.abort()

        tester.testDone()

        tester.groupDone()
    finally:
        db.close()

