
import os, string, cStringIO
from Ft.Lib import XInclude
from xml.dom import ext


def Test(tester):
    path = os.path.abspath(__file__)[len(os.getcwd())+1:]
    refUri = string.replace(path, os.sep, '/')

    tester.startGroup("XInclude")
    tester.startTest("simple XInclude")
    doc = XInclude.ProcessIncludesFromString(SRC_1, baseUri=refUri)
    st = cStringIO.StringIO()
    ext.PrettyPrint(doc,stream=st)
    tester.compare(expected_1,st.getvalue())
    tester.testDone()

    tester.startTest("Recursive XInclude")
    doc = XInclude.ProcessIncludesFromString(SRC_2, baseUri=refUri)
    st = cStringIO.StringIO()
    ext.PrettyPrint(doc,stream=st)
    tester.compare(expected_2,st.getvalue())
    tester.testDone()

    tester.startTest("XInclude text attribute")
    doc = XInclude.ProcessIncludesFromString(SRC_3, baseUri=refUri)
    st = cStringIO.StringIO()
    ext.PrettyPrint(doc,stream=st)
    tester.compare(expected_3,st.getvalue())
    tester.testDone()

    tester.groupDone()


SRC_1="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include1.xml"/>
</x>"""

expected_1 = """<?xml version='1.0' encoding='UTF-8'?>
<x xmlns:xi='http://www.w3.org/2001/XInclude'>
  <foo/>
</x>
"""

SRC_2="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include2.xml"/>
</x>"""

expected_2="""<?xml version='1.0' encoding='UTF-8'?>
<x xmlns:xi='http://www.w3.org/2001/XInclude'>
  <foo>
    <foo/>
  </foo>
</x>
"""

SRC_3="""<?xml version='1.0'?><x xmlns:xi="http://www.w3.org/2001/XInclude">
<xi:include href="include2.xml" parse='text'/>
</x>"""

expected_3="""<?xml version='1.0' encoding='UTF-8'?>
<x xmlns:xi='http://www.w3.org/2001/XInclude'>
&lt;?xml version='1.0' encoding='utf-8'?>
&lt;foo xmlns:xi="http://www.w3.org/2001/XInclude">
  &lt;xi:include href="include1.xml"/>
&lt;/foo>
</x>
"""


if __name__ == '__main__':
    from Ft.Lib import TestSuite
    tester = TestSuite.TestSuite(1,1)

    Test(tester)

