import urllib
from Ft.Lib import TestSuite
from Ft.Lib import Uri

test_cases = [
    ('','file:docs/xml/4XLink.api','file:docs/xml/4XLink.api'),
    ('file:docs/xml/','file:docs/xml/4XLink.api','file:docs/xml/4XLink.api'),
    ('file:/usr/local/lib/xslt/bar.xslt','http://4Suite.org/foo.xslt','http://4Suite.org/foo.xslt'),
    ]


def Test(tester):

    tester.startGroup("urllib basejoin")

    #resolver = Uri.BaseUriResolver()
    for base, relative, expectedUri  in test_cases:
        tester.startTest("Uri: base=%s uri=%s" % (base,relative))

        res = urllib.basejoin(base, relative)
        tester.testResults(expectedUri, res, done=0,
                           msg="Invalid Uri")

        tester.testDone()

    tester.groupDone()

if __name__ == '__main__':
    tester = TestSuite.TestSuite(1, 1)
    Test(tester)
