


class PostgresStatement:
    def queryNoArgs(self,db):
        res = db.query(self.command)
        if res:
            try:
                return res.getresult()
            except AttributeError:
                return None
        return None

    def query(self,db,**args):
        res = db.query(self.command%args)
        if res:
            try:
                return res.getresult()
            except AttributeError:
                return None
        return None

    def execute(self,db,**args):
        db.query(self.command%args)
    

    def pprint(self,**args):
        print self.command%args


class NewRepoIdStatement(PostgresStatement):
    command = "SELECT NEXTVAL('ftods_repoid')"
    query = PostgresStatement.queryNoArgs
    
class NewRepoStatement(PostgresStatement):
    command = "INSERT INTO %(tableName)s (_repoid) VALUES(%(rid)i)"
class NewRepoMapStatement(PostgresStatement):
    command = "INSERT INTO ftods_repomap (repoid,meta_kind,pythonclassid) VALUES(%(rid)i,%(metaKind)i, %(pythonclassid)d)"

class GetRepoStatement(PostgresStatement):
    command = "SELECT meta_kind,pythonclassid FROM ftods_repomap WHERE repoid = %(rid)d"
class GetRepoTupleStatement(PostgresStatement):
    command = "SELECT * from %(tableName)s where _repoid = %(rid)d"

class DeleteRepoStatement(PostgresStatement):
    command ="DELETE from %(tableName)s where _repoid = %(rid)d"

class DeleteRepoMapStatement(PostgresStatement):
    command = "DELETE FROM ftods_repomap where repoid = %(rid)i"
    

class UpdateRepoTimeStatement(PostgresStatement):
    command = "UPDATE ftods_repomap set lastUpdate = %(newTime)lf where repoid = %(rid)d"

class CheckRepoTimeStatement(PostgresStatement):
    command = "SELECT repoid FROM ftods_repomap where repoid = %(id)d and lastUpdate <= float8(%(testTime)lf)"



class NewExtentIdStatement(PostgresStatement):
    command = "SELECT NEXTVAL('ftods_extentid')"
    query = PostgresStatement.queryNoArgs

class NewExtentStatement(PostgresStatement):
    command = "INSERT into ftods_extents (name,extentid,persistenttype) VALUES ('%(name)s',%(extentId)d,%(persistentType)d)"

class GetExtentIdStatement(PostgresStatement):
    command = "SELECT extentid from ftods_extents where name = '%(name)s'"


class AddExtentMappingStatement(PostgresStatement):
    command = 'INSERT into ftods_extentmapping (extentid,id) VALUES (%(extentId)d,%(id)s)'

class DropExtentMappingStatement(PostgresStatement):
    command = 'DELETE FROM ftods_extentmapping WHERE extentid = %(extentId)d and id = %(id)d'


class DropAllExtentMappingStatement(PostgresStatement):
    command = 'DELETE FROM ftods_extentmapping WHERE extentid = %(extentId)d'

class DropExtentStatement(PostgresStatement):
    command = "DELETE FROM ftods_extents WHERE extentId = %(extentId)d"

class GetExtentNamesStatement(PostgresStatement):
    command = "SELECT DISTINCT name from ftods_extents"
    query = PostgresStatement.queryNoArgs


class GetExtentIdAndTypeStatement(PostgresStatement):
    command = "SELECT extentid,persistentType from ftods_extents where name = '%(name)s'"

class GetExtentStatement(PostgresStatement):
    command = "SELECT id from ftods_extentmapping where extentId = %(extentId)d"

class GetBoundObjectStatement(PostgresStatement):
    command = "SELECT objid from ftods_binding where name = '%(name)s'"

class AddBoundNameStatement(PostgresStatement):
    command = "INSERT INTO ftods_binding (name,objid) VALUES ('%(name)s',%(oid)d)"

class DropBoundNameStatement(PostgresStatement):
    command = "DELETE FROM ftods_binding where name = '%(name)s'"

class GetBoundNamesStatement(PostgresStatement):
    command = "SELECT name from ftods_binding"
    query = PostgresStatement.queryNoArgs

class GetObjectBoundNamesStatement(PostgresStatement):
    command = "SELECT name from ftods_binding  where objid = '%(oid)d'"


class NewPythonClassIdStatement(PostgresStatement):
    command = "SELECT NEXTVAL('ftods_pythonclassid')"

class NewPythonClassStatement(PostgresStatement):
    command = "INSERT into ftods_pythonclass (pythonclassid,pythonclassname,pythonmodulename) VALUES(%(pid)d,'%(className)s', '%(moduleName)s')"

class GetPythonClassStatement(PostgresStatement):
    command = 'SELECT pythonmodulename, pythonclassname from ftods_pythonclass where pythonclassid = %(pid)d'

class GetPythonClassIdStatement(PostgresStatement):
    command = "SELECT pythonclassid from ftods_pythonclass WHERE pythonmodulename = '%(moduleName)s' and pythonclassname  = '%(className)s'"

class DeletePythonClassStatement(PostgresStatement):
    command = 'DELETE FROM ftods_pythonclass where pythonclassid = %(pid)d'


class NewCollectionIdStatement(PostgresStatement):
    command = "SELECT NEXTVAL('ftods_collectionid')"
    query = PostgresStatement.queryNoArgs

class NewCollectionStatement(PostgresStatement):
    command = "INSERT INTO ftods_collectionclass (_cid,pythonclassid,subtype,subtyperepoid) VALUES (%(cid)i,%(pythonclassid)i,%(subType)i, %(subTypeRepoId)d)"

class UpdateCollectionIndexesAddStatement(PostgresStatement):
    command = 'UPDATE %(tableName)s set index = index + 1 WHERE _cid = %(cid)i and index >= %(index)s'

class NewCollectionEntryStatement(PostgresStatement):
    command = 'INSERT INTO %(tableName)s (_cid,index,value) VALUES (%(cid)i,%(index)i,%(value)s)'

class DeleteCollectionEntryStatement(PostgresStatement):
    command = 'DELETE FROM %(tableName)s WHERE _cid = %(cid)i and index = %(index)i'

class UpdateCollectionIndexesRemoveStatement(PostgresStatement):
    command = 'UPDATE %(tableName)s set index = index - 1 WHERE _cid = %(cid)d and index >= %(index)d'

class DeleteCollectionStatement(PostgresStatement):
    command = "DELETE from ftods_collectionclass where _cid = %(cid)i"

class DeleteCollectionTupleStatement(PostgresStatement):
    command = "DELETE from %(tableName)s where _cid = %(cid)i"

class GetCollectionStatement(PostgresStatement):
    command = "SELECT subtype,subtyperepoid,pythonclassid from ftods_collectionclass where _cid = %(cid)d"
class GetCollectionTupleStatement(PostgresStatement):
    command = "SELECT value from %(tableName)s where _cid = %(cid)d ORDER BY index"

class UpdateCollectionTimeStatement(PostgresStatement):
    command = "UPDATE ftods_collectionclass set lastUpdate = %(newTime)lf where _cid = %(cid)d"

class CheckCollectionTimeStatement(PostgresStatement):
    command = "SELECT _cid FROM ftods_collectionclass where _cid = %(id)d and lastUpdate <= float8(%(testTime)lf)"

class NewObjectIdStatement(PostgresStatement):
    command = "SELECT NEXTVAL('ftods_objid')"
    query = PostgresStatement.queryNoArgs

class NewObjectMapStatement(PostgresStatement):
    command = "INSERT INTO ftods_actualclass (_oid,pythonclassid) VALUES(%(oid)i, %(pythonclassid)d)"

class NewObjectStatement(PostgresStatement):
    command = "INSERT INTO %(tableName)s (_oid) VALUES(%(oid)i)"

class UpdateObjectTimeStatement(PostgresStatement):
    command = "UPDATE ftods_actualclass set lastUpdate = %(newTime)lf where _oid = %(oid)d"

class GetObjectStatement(PostgresStatement):
    command = "SELECT pythonclassid FROM ftods_actualclass WHERE _oid = %(oid)d"

class GetObjectTupleStatement(PostgresStatement):
    command = "SELECT * from %(tableName)s where _oid = %(oid)d"

class GetObjectIdsStatement(PostgresStatement):
    command = "SELECT _oid FROM ftods_actualclass"
    
class CheckObjectTimeStatement(PostgresStatement):
    command = "SELECT _oid FROM ftods_actualclass where _oid = %(id)d and lastUpdate <= float8(%(testTime)lf)"

class DeleteObjectStatement(PostgresStatement):
    command ="DELETE from %(tableName)s where _oid = %(oid)d"

class DeleteObjectMapStatement(PostgresStatement):
    command = "DELETE FROM ftods_actualclass where _oid = %(oid)i"





class NewDictionaryIdStatement(PostgresStatement):
    command = "SELECT NEXTVAL('ftods_dictionaryid')"
    query = PostgresStatement.queryNoArgs

class NewDictionaryStatement(PostgresStatement):
    command = "INSERT INTO ftods_dictionaryclass (_did,pythonclassid,keytype,subtype,keytyperepoid,subtyperepoid) VALUES (%(did)i,%(pythonclassid)i,%(keyType)i,%(subType)i, %(keytyperepoid)d, %(subtyperepoid)d)"


class NewDictionaryEntryStatement(PostgresStatement):
    command = "INSERT INTO ftods_dictionarydata (_did,key,value) VALUES (%(did)i,'%(key)s','%(value)s')"

class UpdateDictionaryEntryStatement(PostgresStatement):
    command = "UPDATE ftods_dictionarydata SET value = '%(value)s' WHERE _did = %(did)i AND key = '%(key)s'"

class DeleteDictionaryEntryStatement(PostgresStatement):
    command = "DELETE FROM ftods_dictionarydata WHERE _did = %(did)i and key = '%(key)s'"

class DeleteDictionaryStatement(PostgresStatement):
    command = "DELETE from ftods_dictionaryclass where _did = %(did)i"

class DeleteDictionaryTupleStatement(PostgresStatement):
    command = "DELETE from ftods_dictionarydata where _did = %(did)i"

class GetDictionaryStatement(PostgresStatement):
    command = "SELECT keytype,keytyperepoid,subtype,subtyperepoid,pythonclassid from ftods_dictionaryclass where _did = %(did)d"
class GetDictionaryTupleStatement(PostgresStatement):
    command = "SELECT key,value from ftods_dictionarydata where _did = %(did)d"

class UpdateDictionaryTimeStatement(PostgresStatement):
    command = "UPDATE ftods_dictionaryclass set lastUpdate = %(newTime)lf where _did = %(did)d"

class CheckDictionaryTimeStatement(PostgresStatement):
    command = "SELECT _did FROM ftods_dictionaryclass where _did = %(id)d and lastUpdate <= float8(%(testTime)lf)"



class NewLiteralClassStatement(PostgresStatement):
    command = "INSERT into ftods_literalclass (pythonclassname,pythonmodulename,type, repoid) VALUES('%(className)s', '%(moduleName)s', %(type)d, %(repoid)d)"

class GetLiteralClassStatement(PostgresStatement):
    command = 'SELECT pythonmodulename, pythonclassname from ftods_literalclass where type = %(type)d and repoid = %(repoid)d'

class DeleteLiteralClassStatement(PostgresStatement):
    command = 'DELETE FROM ftods_literalclass where type = %(type)d and repoid = %(repoid)d'


class InsertOperationStatement(PostgresStatement):
    command = "INSERT into ftods_operationdata (repoId,functionname,blobid) VALUES('%(repoId)d', '%(functionName)s', %(blobId)d)"

class UpdateOperationStatement(PostgresStatement):
    command = "UPDATE ftods_operationdata SET functionname = '%(functionName)s', blobid = %(blobId)d WHERE repoid = %(repoId)d"

class GetOperationStatement(PostgresStatement):
    command = "SELECT functionname,blobid from ftods_operationdata WHERE repoid = %(repoId)d"
    #command = "SELECT meta_kind,pythonclassid FROM ftods_repomap WHERE repoid = %(repoId)d"
