############################################################################
#
# File Name: 		Bag.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Bag.py.html
#
"""
Bag: pretty much just a collection.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


from Ft.Ods.StorageManager.Adapters import Constants

from Ft.Ods.Collections import CollectionBase
class BagBase:

    _collectionType = Constants.CollectionTypes.BAG

    def is_ordered(self):
        return 0

    def allows_duplicates(self):
        return 1


    def occurrences_of(self, element):
        el = self._4ods_unprepareValue(element)
        return self._values.values().count(el)


    def create_union(self, other_bag):
        result = self.copy(deep=0)
        for item in other_bag:
            if self.contains_element(item):
                result.insert_element(item)
        return result

    def create_intersection(self, other_bag):
        result = self.copy(deep=0)
        for item in self:
            if not item in result:
                result.insert_element(item)
        for item in other_bag:
            if not item in result:
                result.insert_element(item)
        return result

    def create_difference(self, other_bag):
        result_list = []
        result = self.copy(deep=0)
        for item in other_bag:
            if not self.contains_element(item):
                CollectionBase.CollectionBase.insert_element(result,item)
        for item in self:
            if not other_bag.contains_element(item):
                CollectionBase.CollectionBase.insert_element(result,item)

        return result

    def _4ods_getOdsType(self):
        return Constants.Types.BAG_COLLECTION
