#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "ds_primitives.h"

void list_init(List *list, void (*destroy)(void *data)) {

list->size = 0;
list->destroy = destroy;
list->head = NULL;
list->tail = NULL;

return;

}

void list_destroy(List *list) {

void               *data;

while (list_size(list) > 0) {

   if (list_rem_next(list, NULL, (void **)&data) == 0 && list->destroy !=
      NULL) {
      list->destroy(data);
   }

}

memset(list, 0, sizeof(List));

return;

}


int list_ins_next(List *list, ListElmt *element, const void *data) {

ListElmt           *new_element;

if ((new_element = (ListElmt *)malloc(sizeof(ListElmt))) == NULL)
   return -1;

new_element->data = (void *)data;

if (element == NULL) {
   /* insert it at the beginning */
   if (list_size(list) == 0)
      list->tail = new_element;

   new_element->next = list->head;
   list->head = new_element;
} else {
   /* insert it AFTER the given element */
   if (element->next == NULL)
      list->tail = new_element;

   new_element->next = element->next;
   element->next = new_element;
}

list->size++;

return 0;

}

int list_rem_next(List *list, ListElmt *element, void **data) {

ListElmt           *old_element;

if (list_size(list) == 0)
   return -1;

if (element == NULL) {

   *data = list->head->data;
   old_element = list->head;
   list->head = list->head->next;

   if (list_size(list) == 1)
      list->tail = NULL;

   }

else {

   if (element->next == NULL)
      return -1;

   *data = element->next->data;
   old_element = element->next;
   element->next = element->next->next;

   if (element->next == NULL)
      list->tail = element;

}

free(old_element);

list->size--;

return 0;

}


int _stack_push(Stack *stack, const void *data) {

return list_ins_next(stack, NULL, data);

}

int _stack_pop(Stack *stack, void **data) {

return list_rem_next(stack, NULL, data);

}



void set_init(Set *set, int (*match)(const void *key1, const void *key2),
   void (*destroy)(void *data)) {

list_init(set, destroy);
set->match = match;

return;

}

int set_insert(Set *set, const void *data) {

if (set_is_member(set, data))
   return 1;

return list_ins_next(set, list_tail(set), data);

}

int set_remove(Set *set, void **data) {

ListElmt           *member,
                   *prev;

prev = NULL;

for (member = list_head(set); member != NULL; member = list_next(member)) {

   if (set->match(*data, list_data(member)))
      break;

   prev = member;

}

if (member == NULL)
   return -1;

return list_rem_next(set, prev, data);

}

int set_union(Set *setu, const Set *set1, const Set *set2) {

ListElmt           *member;

void               *data;

set_init(setu, set1->match, NULL);

for (member = list_head(set1); member != NULL; member = list_next(member)) {

   data = list_data(member);

   if (list_ins_next(setu, list_tail(setu), data) != 0) {

      set_destroy(setu);
      return -1;

   }

}

for (member = list_head(set2); member != NULL; member = list_next(member)) {

   if (set_is_member(set1, list_data(member))) {

      continue;

      }

   else {

      data = list_data(member);

      if (list_ins_next(setu, list_tail(setu), data) != 0) {

         set_destroy(setu);
         return -1;

      }

   }

}

return 0;

}

int set_intersection(Set *seti, const Set *set1, const Set *set2) {

ListElmt           *member;

void               *data;

set_init(seti, set1->match, NULL);

for (member = list_head(set1); member != NULL; member = list_next(member)) {

   if (set_is_member(set2, list_data(member))) {

      data = list_data(member);

      if (list_ins_next(seti, list_tail(seti), data) != 0) {

         set_destroy(seti);
         return -1;

      }

   }

}

return 0;

}

int set_difference(Set *setd, const Set *set1, const Set *set2) {

ListElmt           *member;

void               *data;

set_init(setd, set1->match, NULL);

for (member = list_head(set1); member != NULL; member = list_next(member)) {

   if (!set_is_member(set2, list_data(member))) {

      data = list_data(member);

      if (list_ins_next(setd, list_tail(setd), data) != 0) {

         set_destroy(setd);
         return -1;

      }

   }

}

return 0;

}

int set_is_member(const Set *set, const void *data) {

ListElmt           *member;

for (member = list_head(set); member != NULL; member = list_next(member)) {

   if (set->match(data, list_data(member)))
      return 1;

}

return 0;

}

int set_is_subset(const Set *set1, const Set *set2) {

ListElmt           *member;

if (set_size(set1) > set_size(set2))
   return 0;

for (member = list_head(set1); member != NULL; member = list_next(member)) {

   if (!set_is_member(set2, list_data(member)))
      return 0;

}

return 1;

}

int set_is_equal(const Set *set1, const Set *set2) {

if (set_size(set1) != set_size(set2))
   return 0;

return set_is_subset(set1, set2);

}


ListElmt *list_find(List *l, void *target, int (*cmp)(const void *target, const void *candidate))
{
  ListElmt *curr = NULL;
  int found;

  curr = list_head(l);

  for (found = 0; curr && !found; curr = list_next(curr)){
    found = cmp((void *)target, (void *)list_data(curr));
    if (found) break;
  }
  return curr;
}


int list_find_remove(List *l, void *target, void **data, int (*cmp)(const void *target, const void *candidate))
{
  ListElmt *curr = NULL, *last = NULL;
  int found;

  curr = list_head(l);

  for (found = 0; curr && !found; last = curr, curr = list_next(curr)){
    found = cmp((void *)target, (void *)list_data(curr));
    if (found) break;
  }
  list_rem_next(l, last, data);
  return found;
}


void list_foreach(List *l, void (*func)(void *data))
{
  ListElmt *curr = NULL;

  curr = list_head(l);

  for (; curr; curr = list_next(curr)){
    func((void *)list_data(curr));
  }
  return;
}


int chtbl_init(CHTbl *htbl, int buckets,
               int (*hash)(const void *key),
               int (*match)(const void *key1, const void *key2),
               void (*destroy)(void *data))
{
  int i;

  if ((htbl->table = (List *)malloc(buckets * sizeof(List))) == NULL)
    return -1;

  htbl->buckets = buckets;

  for (i = 0; i < htbl->buckets; i++)
    list_init(&htbl->table[i], destroy);

  htbl->hash = hash;
  htbl->match = match;
  htbl->destroy = destroy;

  htbl->size = 0;

  return 0;
}


void chtbl_destroy(CHTbl *htbl)
{
  int i;
  for (i = 0; i < htbl->buckets; i++) {
    list_destroy(&htbl->table[i]);
  }

  free(htbl->table);

  memset(htbl, 0, sizeof(CHTbl));

  return;
}

/* Assumes that key is NOT already in table */
int chtbl_insert(CHTbl *htbl, const void *data)
{
  int retval;
  int bucket = htbl->hash(data) % htbl->buckets;

  if ((retval = list_ins_next(&htbl->table[bucket], NULL, data)) == 0)
    htbl->size++;

  return retval;
}


int chtbl_remove(CHTbl *htbl, void **data)
{
  ListElmt *element, *prev;

  int bucket = htbl->hash(*data) % htbl->buckets;

  prev = NULL;

  for (element = list_head(&htbl->table[bucket]);
       element != NULL;
       element = list_next(element))
    {

      if (htbl->match(*data, list_data(element)))
        {

          if (list_rem_next(&htbl->table[bucket], prev, data) == 0)
            {
              htbl->size--;
              return 0;
            }
          else {
            return -1;
          }
        }
      prev = element;
    }

  return -1;
}

int chtbl_lookup(const CHTbl *htbl, void **data)
{
  ListElmt *element;
  int bucket = htbl->hash(*data) % htbl->buckets;

  for (element = list_head(&htbl->table[bucket]);
       element != NULL;
       element = list_next(element)) {
    if (htbl->match(*data, list_data(element))) {
      *data = list_data(element);
      return 0;
    }
  }
  return -1;
}
