<?php

/*
 * This example draws a variety of shapes on an otherwise black image.
 * Demonstrates draw/filled rectangles, polygins, cliprects, ellipses, etc.
 */

require './class.ImlibImage.php';
require './class.ImlibColor.php';
require './class.ImlibText.php';
require './class.ImlibCliprect.php';
require './class.ImlibDraw.php';
require './class.ImlibPoly.php';

$im = new ImlibImage();
$im->create(225,260);

$outlinecolor = Array(255,0,0,255);
$color = Array(255,127,0,255);

$box = new ImlibDraw();
$box->set_image($im->get_id());
$box->set_color_array($outlinecolor);
$box->draw_rectangle(7,7,106,56);
$box->set_color_array($color);
$box->fill_rectangle(10,10,100,50);

$poly = new ImlibPoly();
$poly->new_poly();
$poly->set_image($im->get_id());
$poly->set_color(255,0,255,255);
$poly->add_point(100,100);
$poly->add_point(215,110);
$poly->add_point(150,215);
$poly->add_point(102,255);

// The cliprect will leave a gap in the middle of this polygon
$poly->set_cliprect(100,50,125,110);	// Draw the top
$poly->draw();
$poly->set_cliprect(100,190,125,70);	// Draw the bottom
$poly->draw();
$poly->free();

$poly->set_cliprect(0,0,0,0);	// Turns off the clipping rectangle
$poly->new_poly();
$poly->set_color(255,255,255,255);
$poly->add_point(106,106);
$poly->add_point(205,115);
$poly->add_point(147,211);
$poly->add_point(106,245);

$poly->draw();
$poly->free();

// This will draw a few pseudo-randomly colored ellipses
$j = 30;
for ($i = 90; $i < 260; $i += 20)
{
   $box->set_color($i,$i*2,255-$i*2,255);
   $box->draw_ellipse($j,$i,10,$j/2);
   $j += 20;
   if ($j > 70)
      $j = 25;
}

$im->save('./draw.png');
$im->free();

?>
