# This script was automatically generated from the dsa-503
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
A problem has been discovered in mah-jong, a variant of the original
Mah-Jong game, that can be utilised to crash the game server after
dereferencing a NULL pointer.  This bug be exploited by any client
that connects to the mah-jong server.
For the stable distribution (woody) this problem has been fixed in
version 1.4-3.
For the unstable distribution (sid) this problem has been fixed in
version 1.6.2-1.
We recommend that you upgrade your mah-jong package.


Solution : http://www.debian.org/security/2004/dsa-503
Risk factor : High';

if (description) {
 script_id(15340);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "503");
 script_cve_id("CAN-2004-0458");
 script_bugtraq_id(10343);

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2004 Michel Arboi");
 script_name(english: "[DSA503] DSA-503-1 mah-jong");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-503-1 mah-jong");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'mah-jong', release: '3.0', reference: '1.4-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mah-jong is vulnerable in Debian 3.0.\nUpgrade to mah-jong_1.4-3\n');
}
if (deb_check(prefix: 'mah-jong', release: '3.2', reference: '1.6.2-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mah-jong is vulnerable in Debian sid.\nUpgrade to mah-jong_1.6.2-1\n');
}
if (deb_check(prefix: 'mah-jong', release: '3.0', reference: '1.4-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mah-jong is vulnerable in Debian woody.\nUpgrade to mah-jong_1.4-3\n');
}
if (w) { security_hole(port: 0, data: desc); }
