/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.OutputMethodHandler;
import com.jclark.xsl.sax.ResultBase;
import com.jclark.xsl.sax.ResultTreeFragment;
import com.jclark.xsl.tr.Result;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class MultiNamespaceResult
extends ResultBase {
    private NamespacePrefixMap[] elementMaps = new NamespacePrefixMap[20];
    private NamespacePrefixMap currentMap = null;
    private int elementDepth = 0;
    private String[] attributeNameStrings = new String[20];
    private String[] pseudoAttributeValues = new String[10];
    private int nPseudoAttributes = 0;

    public MultiNamespaceResult(OutputMethodHandler outputMethodHandler, ErrorHandler errorHandler) {
        super(outputMethodHandler, errorHandler);
    }

    public MultiNamespaceResult(DocumentHandler documentHandler, ErrorHandler errorHandler) {
        super(documentHandler, errorHandler);
    }

    public Result createResult(String uri) throws XSLException {
        OutputMethodHandler om;
        if (this.outputMethodHandler != null && (om = this.outputMethodHandler.createOutputMethodHandler(uri)) != null) {
            return new MultiNamespaceResult(om, this.errorHandler);
        }
        return null;
    }

    protected void startElementContent(Name elementType, NamespacePrefixMap map) throws XSLException {
        int nAtts;
        if (this.elementDepth >= this.elementMaps.length) {
            NamespacePrefixMap[] oldElementMaps = this.elementMaps;
            this.elementMaps = new NamespacePrefixMap[oldElementMaps.length * 2];
            System.arraycopy(oldElementMaps, 0, this.elementMaps, 0, oldElementMaps.length);
        }
        this.elementMaps[this.elementDepth++] = this.currentMap;
        this.nPseudoAttributes = 0;
        if (map != this.currentMap) {
            int size = map.getSize();
            boolean changed = false;
            for (int i = 0; i < size; ++i) {
                String prefix = map.getPrefix(i);
                String namespace = map.getNamespace(i);
                if (this.currentMap != null && namespace.equals(this.currentMap.getNamespace(prefix))) continue;
                changed = true;
                this.addPseudoAttribute("xmlns:" + prefix, namespace);
            }
            String defaultNamespace = map.getDefaultNamespace();
            if (defaultNamespace == null) {
                if (this.currentMap == null) {
                    changed = true;
                } else if (this.currentMap.getDefaultNamespace() != null) {
                    this.addPseudoAttribute("xmlns", "");
                    changed = true;
                }
            } else if (this.currentMap == null || !defaultNamespace.equals(this.currentMap.getDefaultNamespace())) {
                changed = true;
                this.addPseudoAttribute("xmlns", defaultNamespace);
            }
            if (changed) {
                this.currentMap = map;
            }
        }
        if (this.attributeNameStrings.length <= (nAtts = super.getLength())) {
            this.attributeNameStrings = new String[nAtts];
        }
        for (int i = 0; i < nAtts; ++i) {
            this.attributeNameStrings[i] = this.getAttributeNameString(this.getAttributeName(i));
        }
        try {
            this.getDocumentHandler().startElement(elementType.toString(), this);
        }
        catch (SAXException e) {
            this.throwXSLException(e);
        }
    }

    protected void endElementContent(Name elementType) throws XSLException {
        try {
            this.getDocumentHandler().endElement(elementType.toString());
        }
        catch (SAXException e) {
            this.throwXSLException(e);
        }
        this.currentMap = this.elementMaps[--this.elementDepth];
    }

    public String getName(int i) {
        return this.attributeNameStrings[i];
    }

    public String getValue(int i) {
        int n = super.getLength();
        if (i < n) {
            return super.getValue(i);
        }
        return this.pseudoAttributeValues[i - n];
    }

    public int getLength() {
        return super.getLength() + this.nPseudoAttributes;
    }

    private void addPseudoAttribute(String name, String value) {
        if (this.nPseudoAttributes >= this.pseudoAttributeValues.length) {
            this.pseudoAttributeValues = MultiNamespaceResult.grow(this.pseudoAttributeValues);
        }
        this.pseudoAttributeValues[this.nPseudoAttributes] = value;
        int n = this.nPseudoAttributes++ + super.getLength();
        while (n >= this.attributeNameStrings.length) {
            this.attributeNameStrings = MultiNamespaceResult.grow(this.attributeNameStrings);
        }
        this.attributeNameStrings[n] = name;
    }

    private String getAttributeNameString(Name name) throws XSLException {
        String namespace = name.getNamespace();
        if (namespace == null) {
            return name.toString();
        }
        if (namespace.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml:" + name.getLocalPart();
        }
        String prefix = name.getPrefix();
        if (prefix != null && namespace.equals(this.currentMap.getNamespace(prefix))) {
            return name.toString();
        }
        String newPrefix = this.currentMap.getPrefix(namespace);
        if (newPrefix != null) {
            return newPrefix + ":" + name.getLocalPart();
        }
        if (prefix != null && this.currentMap.getNamespace(prefix) == null) {
            this.addPseudoAttribute("xmlns:" + prefix, namespace);
            this.currentMap = this.currentMap.bind(prefix, namespace);
            return name.toString();
        }
        int j = 0;
        while (this.currentMap.getPrefix(newPrefix = "ns" + Integer.toString(j)) != null) {
            ++j;
        }
        this.addPseudoAttribute("xmlns:" + newPrefix, namespace);
        this.currentMap = this.currentMap.bind(newPrefix, namespace);
        return newPrefix + ":" + name.getLocalPart();
    }

    public void resultTreeFragment(ResultTreeFragment frag) throws XSLException {
        try {
            this.flush();
            frag.emit(this.getDocumentHandler());
        }
        catch (SAXException e) {
            this.throwXSLException(e);
        }
    }
}

