#include <synaptics.h>

#include <stdlib.h>

using namespace Synaptics;

int main( int argc, char* argv[] )
{
    if ( argc == 1 )
    {
        std::list<std::string> params;
        params = Pad::getAvailableParams();

        std::list<std::string>::iterator it;

        for ( it = params.begin(); it != params.end(); it++ )
        {
            std::cout << *it << "=" << Pad::getParam( *it ) << std::endl;
        }
        return 0;
    }

    if ( argc == 2 )
    {
        if ( Pad::hasParam( argv[1] ) )
            std::cout << argv[1] << " = " << Pad::getParam( argv[1] ) << std::endl;
        else
            std::cout << "unknown parameter " << argv[1] << std::endl;
    }

    if ( argc == 3 )
    {
        if ( Pad::hasParam( argv[1] ) )
        {
            if ( Pad::getParamMin( argv[1] ) > Pad::getParamMax( argv[1] ) )
                std::cout << "parameter is read only!" << std::endl;
            else
            {
                if ( Pad::getParamMin( argv[1] ) > atof( argv[2] ) )
                    std::cout << "value is too low!" << std::endl;
                else
                    Pad::setParam( argv[1], atof( argv[2]  ) );
                
                if ( Pad::getParamMax( argv[1] ) < atof( argv[2] ) )
                    std::cout << "value is too high!" << std::endl;
                else
                    Pad::setParam( argv[1], atof( argv[2]  ) );
            }
        }
        else
            std::cout << "unknown parameter " << argv[1] << std::endl;
    }

    std::cout << "synclient "; if ( !Pad::hasSynClient() ) std::cout << "not "; std::cout << "found" << std::endl;
    std::cout << "syndaemon "; if ( !Pad::hasSynDaemon() ) std::cout << "not "; std::cout << "found" << std::endl;

    return 1;
}
