/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.*;
import com.sap.dbtech.jdbc.exceptions.*;
import com.sap.dbtech.util.*;

/**
 *
 */
public class GetvalUnicode
    extends AbstractGetval
{
    private boolean isUnicodeColumn;
    /**
     * creates a new GetvalUnicode
     */
    public
    GetvalUnicode (ConnectionSapDB connection, byte [] descriptor, StructuredMem dataPart, boolean isUnicodeColumn, boolean isPacketEncodingUnicode)
    {
        super (connection, descriptor, dataPart, 2, isPacketEncodingUnicode);
        this.isUnicodeColumn = isUnicodeColumn;
    }
    public long length() throws java.sql.SQLException
    {

       return (this.lengthInBytes()/((this.isUnicodeColumn)?2:1));
    }
    /**
     *
     * @return
     *
     * @exception SQLException
     */
    public java.io.InputStream getAsciiStream ()
    throws java.sql.SQLException
    {
        return new ReaderInputStream (this.getCharacterStream (),false);
    }
    /**
     *
     * @return
     *
     * @exception SQLException
     */
    public java.io.InputStream getBinaryStream ()
    throws java.sql.SQLException
    {
        return new ReaderInputStream (this.getCharacterStream (), false);
    }
    /**
     *
     * @return
     *
     * @exception SQLException
     */
    public java.io.Reader getCharacterStream ()
    throws java.sql.SQLException
    {
        return new Reader ();
    }
    /**
     *
     */
    public class Reader
        extends java.io.Reader
    {
//        private String cachedValue = null;
        /**
         * read method comment.
         */
        public int read()
        throws StreamIOException
        {
            int result;

            if (GetvalUnicode.this.itemsInBuffer <= 0) {
                GetvalUnicode.this.nextChunk ();
            }
            if (GetvalUnicode.this.atEnd) {
                return -1;
            }
            result = GetvalUnicode.this.streamBuffer.getBigUnicodeChar (0);
            GetvalUnicode.this.streamBuffer.moveBase (UnicodeUtil.CharWidthC);
            --GetvalUnicode.this.itemsInBuffer;
            ++GetvalUnicode.this.longPosition;
            return result;
        }
        /**
         *
         * @return int
         * @param b char[]
         * @param off int
         * @param len int
         * @exception StreamIOException
         */
        public  int read(char b[], int off, int len)
        throws StreamIOException
        {
//            int originalOffset = off;
            int charsCopied = 0;
            int chunkChars;
            int chunkBytes;
            char [] chunk;

            while ((len > 0) && !GetvalUnicode.this.atEnd) {
                if (GetvalUnicode.this.itemsInBuffer <= 0) {
                    GetvalUnicode.this.nextChunk ();
                }
                if (!GetvalUnicode.this.atEnd ) {
                    /*
                     * copy bytes in buffer
                     */
                    chunkChars = java.lang.Math.min (len, GetvalUnicode.this.itemsInBuffer);
                    chunkBytes = chunkChars * UnicodeUtil.CharWidthC;
                    chunk = GetvalUnicode.this.streamBuffer.getBigUnicode (0, chunkBytes);
                    System.arraycopy (chunk, 0, b, off, chunkChars);
                    len -= chunkChars;
                    off += chunkChars;
                    GetvalUnicode.this.itemsInBuffer -= chunkChars;
                    GetvalUnicode.this.streamBuffer.moveBase (chunkBytes);
                    charsCopied += chunkChars;
                }
            }
            if ((charsCopied == 0) && GetvalUnicode.this.atEnd) {
                charsCopied = -1;
            }
            else {
                GetvalUnicode.this.longPosition += charsCopied;
            }
            // this.dumpReadResult (b, originalOffset, charsCopied);
            return charsCopied;
        }
        /**
         *
         */
        protected void
        dumpReadResult (
            char [] b,
            int offs,
            int charsCopied)
        {
            String repr;

            if (charsCopied <= 32) {
                repr = new String (b, offs, charsCopied);
            }
            else {
                String start = new String (b, offs, 16);
                String end = new String (b, offs + charsCopied - 16, 16);
                repr = start + "..." + end;
            }
            System.out.println ("        => [" + charsCopied + "] '" + repr + "'"); //#print
        }
        /**
         *
         */
        public void
        close ()
        {
        }
/*************************************************************************
*   Uncomment this if you want to display LONG columns in DB Visualizer
*    or any other tool that uses getObject ().toString ()
*    instead of getString ()
*         /**                                                            *
*          *                                                             *
*          *                                                             *
*         public String                                                  *
*         toString ()                                                    *
*         {                                                              *
*             if (this.cachedValue != null) {                            *
*                 return this.cachedValue;                               *
*             }                                                          *
*             java.io.StringWriter writer = new java.io.StringWriter (); *
*             char [] buf = new char [4096];                             *
*             int chunkRead;                                             *
*             try {                                                      *
*                 do {                                                   *
*                     chunkRead = this.read (buf, 0, 4096);              *
*                     if (chunkRead > 0) {                               *
*                         writer.write (buf, 0, chunkRead);              *
*                     }                                                  *
*                 } while (chunkRead > 0);                               *
*             }                                                          *
*             catch (java.io.IOException exc) {                          *
*             }                                                          *
*             this.cachedValue = writer.toString();                      *
*             return this.cachedValue;                                   *
*         }                                                              *
*     }                                                                  *
*************************************************************************/
    }
}
